<?php 
session_start();
setlocale( LC_TIME, 'es_MX.UTF-8', 'esp' );
date_default_timezone_set( 'America/Mazatlan' );
include 'func/conn.php';

$sessData = !empty( $_SESSION[ 'sessData' ] ) ? $_SESSION[ 'sessData' ] : '';
if ( !empty( $sessData[ 'status' ][ 'msg' ] ) ) {
  $statusMsg = $sessData[ 'status' ][ 'msg' ];
  $statusMsgType = $sessData[ 'status' ][ 'type' ];
  unset( $_SESSION[ 'sessData' ][ 'status' ] );
}

if ( isset( $_SESSION[ 'sessData' ] ) && $_SESSION[ 'sessData' ] == true ) {} else {

  echo '<script type="text/javascript">window.location.href="login.php";
    </script>';
  exit;
}

if ( !empty( $sessData[ 'userLoggedIn' ] ) && !empty( $sessData[ 'userID' ] ) ) {
  include 'func/user.php';
  $user = new User();
  $conditions[ 'where' ] = array(
    'id' => $sessData[ 'userID' ],
  );
  $conditions[ 'return_type' ] = 'single';
  $userData = $user->getRows( $conditions );
  $userName = $userData[ 'first_name' ];
  $user_lastname = $userData[ 'last_name' ];
  $email = $userData[ 'email' ];
  $ida = $userData[ 'ida' ];
  $avatar = $userData[ 'avatar' ];
}



$sql = "SELECT * FROM generales WHERE ida = '$ida'";
$result = $conn->query( $sql );

if ( $result->num_rows > 0 ) {
  // output data of each row
  while ( $row = $result->fetch_assoc() ) {

    $empresa = $row[ "empresa" ];
    $logo = $row[ "logo" ];
    $empresa_telefono = $row[ "telefono" ];
    $empresa_email = $row[ "email" ];

  }

}

function GeraHash( $qtd ) {

  $Caracteres = '0123456789';
  $QuantidadeCaracteres = strlen( $Caracteres );
  $QuantidadeCaracteres--;

  $Hash = NULL;
  for ( $x = 1; $x <= $qtd; $x++ ) {
    $Posicao = rand( 0, $QuantidadeCaracteres );
    $Hash .= substr( $Caracteres, $Posicao, 1 );
  }

  return $Hash;
}
$idr = GeraHash( 8 );

$titulo = "Reservas";
?>
<!DOCTYPE html>

<html
  lang="en"
  class="light-style layout-navbar-fixed layout-menu-fixed"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="assets/"
  data-template="vertical-menu-template"
>
  <head>
    <meta charset="utf-8" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"
    />

    <title><?php echo $titulo ?></title>

    

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.ico" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&family=Rubik:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />

    <!-- Icons -->
    <link rel="stylesheet" href="assets/vendor/fonts/boxicons.css" />
    <link rel="stylesheet" href="assets/vendor/fonts/fontawesome.css" />
    <link rel="stylesheet" href="assets/vendor/fonts/flag-icons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor/css/rtl/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor/css/rtl/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="assets/vendor/libs/typeahead-js/typeahead.css" />
    <link rel="stylesheet" href="assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
    <link rel="stylesheet" href="assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
    <link rel="stylesheet" href="assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" />
    <link rel="stylesheet" href="assets/vendor/libs/sweetalert2/sweetalert2.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker3.min.css" integrity="sha512-rxThY3LYIfYsVCWPCW9dB0k+e3RZB39f23ylUYTEuZMDrN/vRqLdaCBo/FbvVT6uC2r0ObfPzotsfKF9Qc5W5g==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="assets/vendor/js/helpers.js"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Template customizer: To hide customizer set displayCustomizer value false in config.js.  -->
    <script src="assets/vendor/js/template-customizer.js"></script>
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
  </head>

  <body>
    <input type="hidden" id="ida" value="<?php echo $ida; ?>">
    <input type="hidden" id="idrAsingado" value="<?php echo $idr; ?>">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <?php include('layout/menu.php'); ?>
        <!-- / Menu -->
        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->
          <?php include('layout/navbar.php'); ?>
          <!-- / Navbar -->
          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->
            <div class="container-xxl flex-grow-1 container-p-y">
              <div class="row">
                <div class="card mb-4">
                  <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title"><?php echo $titulo ?></h3>
                    <div class="card-toolbar">
                    <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#crear_reserva_modal" id="crear_tarifa">
                        Crear Reserva
                      </button> 
                    </div>
                  </div>
                  <div class="table-responsive mb-3">
                    <table class="table" id="reservas_table">
                      <thead>
                        <tr>
                          <th></th>
                          <th></th>
                          <th>Voucher</th>
                          <th>Nombre</th>
                          <th>Agencia</th>
                          <th>Proveedor</th>
                          <th>Chofer</th>
                          <th>Hotel</th>
                          <th>Servicio</th>
                          <th>Vehiculo</th>
                          <th>Fecha</th>
                          <th style="width: 500px;">Acciones</th>
                        </tr>
                      </thead>
                      <tbody>
                        <!-- Los datos se llenarán mediante AJAX -->
                      </tbody>
                    </table>
                  </div>
                </div>  
              </div>
            </div>
            <!-- / Content -->
            <div class="modal fade"  tabindex="-1" aria-hidden="true">
              <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel2">Reserva - <span id="idr"></span></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                  </div>
                  <div class="modal-body">
                    <div class="row">
                      <div class="col-12 mb-3">
                        <label for="nameSmall" class="form-label">Nombre</label>
                        <input type="text" id="edit_nombre" class="form-control">
                      </div>
                      <div class="col-6 mb-3">
                        <label for="nameSmall" class="form-label">Telefono</label>
                        <input type="text" id="edit_telefono" class="form-control">
                      </div>
                      <div class="col-6 mb-3">
                        <label for="nameSmall" class="form-label">Email</label>
                        <input type="text" id="edit_email" class="form-control">
                      </div>
                      <div class="col-6 mb-3">
                        <label for="nameSmall" class="form-label">Pax</label>
                        <input type="text" id="edit_pax" class="form-control">
                      </div>
                      <div class="col-6 mb-3">
                        <label for="nameSmall" class="form-label">Vehiculo</label>
                        <input type="text" id="edit_car" class="form-control">
                      </div>
                      <div class="col-6 mb-3">
                        <label for="nameSmall" class="form-label">Hotel</label>
                        <input type="text" id="edit_hotel_llegada" class="form-control">
                      </div>
                      <div class="col-6 mb-3">
                        <label for="nameSmall" class="form-label">Servicio</label>
                        <input type="text" id="edit_servicio" class="form-control">
                      </div>
                      <div class="col-6 mb-3">
                        <label for="nameSmall" class="form-label">Fecha Llegada</label>
                        <input type="text" id="edit_fecha_llegada" class="form-control">
                      </div>
                      <div class="col-6 mb-3">
                        <label for="nameSmall" class="form-label">Hora Llegada</label>
                        <input type="text" id="edit_hora_llegada" class="form-control">
                      </div>
                      <div class="col-6 mb-3">
                        <label for="nameSmall" class="form-label">Aerolinea Llegada</label>
                        <input type="text" id="edit_aerolinea_llegada" class="form-control">
                      </div>
                      <div class="col-6 mb-3">
                        <label for="nameSmall" class="form-label">Vuelo Llegada</label>
                        <input type="text" id="edit_vuelo_llegada" class="form-control">
                      </div>
                      <div class="col-4 mb-3">
                        <label for="nameSmall" class="form-label">Fecha Salida</label>
                        <input type="text" id="edit_fecha_salida" class="form-control">
                      </div>
                      <div class="col-4 mb-3">
                        <label for="nameSmall" class="form-label">Hora Salida</label>
                        <input type="text" id="edit_hora_salida" class="form-control">
                      </div>
                      <div class="col-4 mb-3">
                        <label for="nameSmall" class="form-label">Pickup Time</label>
                        <input type="text" id="edit_pickup_time" class="form-control">
                      </div>
                      <div class="col-6 mb-3">
                        <label for="nameSmall" class="form-label">Aerolinea Salida</label>
                        <input type="text" id="edit_aerolinea_salida" class="form-control">
                      </div>
                      <div class="col-6 mb-3">
                        <label for="nameSmall" class="form-label">Vuelo Salida</label>
                        <input type="text" id="edit_vuelo_salida" class="form-control">
                      </div>
                      
                      <div class="col-6 mb-3">
                        <label for="nameSmall" class="form-label">Observaciones</label>
                        <textarea id="edit_observaciones" class="form-control"></textarea>
                      </div>
                      <div class="col-6 mb-3">
                        <label for="nameSmall" class="form-label">Observaciones Internas</label>
                        <textarea id="edit_obs_int" class="form-control"></textarea>
                      </div>
                      <div class="col-4 mb-3">
                        <label for="nameSmall" class="form-label">Baby Seat</label>
                        <input type="text" id="edit_baby_seat" class="form-control">
                      </div>
                      <div class="col-4 mb-3">
                        <label for="nameSmall" class="form-label">Booster Seat</label>
                        <input type="text" id="edit_booster_seat" class="form-control">
                      </div>
                      <div class="col-4 mb-3">
                        <label for="nameSmall" class="form-label">Car Seat</label>
                        <input type="text" id="edit_car_seat" class="form-control">
                      </div>
                      <div class="col-12 mt-3 mb-5">
                        <div class="form-check form-switch">
                          <input class="form-check-input" type="checkbox" id="shopping" name="shopping" value="0">
                          <label class="form-check-label" for="shopping">Shopping-Stop</label>
                        </div>
                      </div>
                      <div class="col-6 mb-5">
                        <label for="nameSmall" class="form-label">Estado Pago</label>
                        <input type="text" id="edit_estado_pago" class="form-control">
                      </div>
                      <div class="col-6 mb-3">
                        <label for="nameSmall" class="form-label">Costo Total</label>
                        <input type="text" id="edit_total" class="form-control">
                      </div>
                    </div>
                    <div class="row g-2">
                      <div class="col mb-0">
                      <input type="hidden" id="id" class="form-control">
                      </div>
                    </div>
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">Cerrar</button>
                    <a type="button" class="btn btn-primary" href="" id="ver_reserva">Enviar Reserva</a>

                  </div>
                </div>
              </div>
            </div>
<!--Modal agregar servicio TRANSPORTACION-->
<div class="modal fade" id="crear_reserva_modal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-simple modal-edit-user">
    <div class="modal-content p-3 p-md-5">
      <div class="modal-body">
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        <div class="text-center mb-4">
          <h3>Generar Reserva</h3>
        </div>
        <form  class="row g-3" method="post" action="servicios.php" id="add-reserva">
          <div class="mt-5">
            <h5>Informacion Personal</h5>
          </div>
          <div class="col-12 col-md-12">
            <label class="form-label" for="name">Agencia</label>
            <select name="agencia" class="form-control" id="agencia">
              <option value="Sin Agencia">Seleccionar Agencia</option>
              <?php
              $sql = "SELECT * FROM proveedores WHERE status <> 4 AND tipo_agencia = 'Agencias' ";
              $result = $conn->query( $sql );
              if ( $result->num_rows > 0 ) {
                while ( $row = $result->fetch_assoc() ) {
                  echo '<option value="' . $row[ 'empresa' ] . '">' . $row[ 'empresa' ] . '</option>';
                }
              }
              ?>
            </select>
          </div>
          <div class="col-12 col-md-12">
            <label class="form-label" for="name">Folio Interno</label>
            <input type="text" id="folio" name="folio" class="form-control" />
          </div>
          <div class="col-12 col-md-12">
            <label class="form-label" for="name">Nombre</label>
            <input type="text" id="name" name="name" class="form-control" oninput="this.value = this.value.toUpperCase()" />
          </div>
          <div class="col-md-6">
            <label class="form-label" for="email">email</label>
            <input
                            type="text"
                            id="email"
                            name="email"
                            class="form-control" 
                            oninput="this.value = this.value.toUpperCase()"
								 />
          </div>
          <div class="col-md-6">
            <label class="form-label" for="phone">Telefono</label>
            <input
                            type="tel"
                            id="phone"
                            name="phone"
                            class="form-control" 
								 />
          </div>
          <div class="col-md-6">
            <label class="form-label" for="pax">Pax</label>
            <input
                            type="number"
                            id="pax"
                            name="pax"
                            class="form-control" 
								 />
          </div>
          <div class="col-6 col-md-6">
            <label class="form-label" for="name">Vehiculo</label>
            <select name="car" class="form-control" id="car">
              <option value="Sin Vehiculo">Sin Vehiculo</option>
              <?php
              $sql = "SELECT * FROM cars WHERE status <> 4 ";
              $result = $conn->query( $sql );
              if ( $result->num_rows > 0 ) {
                while ( $row = $result->fetch_assoc() ) {
                  echo '<option value="' . $row[ 'car' ] . '" >' . $row[ 'car' ] . '</option>';
                }
              }
              ?>
            </select>
          </div>
          <div class="col-md-6">
            <label class="form-label" for="balance">Total / Tarifa</label>
            <input
                            type="text"
                            id="balance"
                            name="total"
                            class="form-control"
                            value=""
							onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" 	 
                          />
                          <div class="form-check form-switch mt-1">
                            <input class="form-check-input" type="checkbox" id="noTotal" name="noTotal" value="mostrar">
									  
                            <label class="form-check-label" for="noTotal">No mostrar total</label>
                          </div>
          </div>
          <div class="col-md-6">
            <label class="form-label" for="balance_real">Monto Pagado</label>
            <input
                            type="text"
                            id="balance_real"
                            name="pagado"
                            class="form-control"
                            value="0"
							onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" 	 
                          />
            <div id="defaultFormControlHelp" class="form-text"> Poner 0 si se pagara en efectivo al llegar </div>
          </div>
          <div class="col-6 col-md-6">
            <label class="form-label" for="car">Pago</label>
             <select name="pay_method" class="form-control" id="pay_method">
             <option value="Payment Pending" selected>Payment Pending</option>
              <option value="Paid">Paid</option>
              <option value="To Pay Online" >To Pay Online</option>
              <option value="To Pay Cash" >To Pay Cash</option>
              <option value="Bank Transfer Pending" >Bank Transfer Pending</option>
            </select>
          </div>
          <div class="col-6 col-md-6">
            <label class="form-label" for="car">Estado de la reserva</label>
             <select name="estado" class="form-control" id="estado_reserva">
             <option value="Confirmed" selected>Confirmed</option>
             <option value="Cancelled ">Cancelled </option>
             <option value="No Show ">No Show </option>
              
            </select>
          </div>
          <div class="col-md-12">
            <div class="mt-5">
              <h5>Tipo de servicio</h5>
            </div>
            <div class="form-check form-check-inline mt-2">
              <input class="form-check-input service_type" type="radio" name="service_type" id="inlineRadio1" value="roa" checked>
              <label class="form-check-label" for="inlineRadio1">Round Trip</label>
            </div>
            <div class="form-check form-check-inline mt-2">
              <input class="form-check-input service_type" type="radio" name="service_type" id="inlineRadio2" value="ona">
              <label class="form-check-label" for="inlineRadio2">Oneway (Arrival)</label>
            </div>
            <div class="form-check form-check-inline mt-2">
              <input class="form-check-input service_type" type="radio" name="service_type" id="inlineRadio3" value="ond" >
              <label class="form-check-label" for="inlineRadio3">Oneway (Departure)</label>
            </div>
            <div class="form-check form-check-inline mt-2">
              <input class="form-check-input service_type" type="radio" name="service_type" id="inlineRadio4" value="tra" >
              <label class="form-check-label" for="inlineRadio4">Transfer (Oneway)</label>
            </div>
            <div class="form-check form-check-inline mt-2">
              <input class="form-check-input service_type" type="radio" name="service_type" id="inlineRadio4" value="trr" >
              <label class="form-check-label" for="inlineRadio4">Transfer (Round Trip)</label>
            </div>
            <div class="form-check form-check-inline mt-2">
              <input class="form-check-input service_type" type="radio" name="service_type" id="inlineRadio5" value="ope" >
              <label class="form-check-label" for="inlineRadio5">Open</label>
            </div>
           
          </div>
          <div class="col-md-6 mt-3">
            <label class="form-label" for="agencia-proveedor">Proveedor</label>
            <select name="agencia-proveedor" class="form-control" id="agencia-proveedor">
              <?php
              $sql = "SELECT * FROM proveedores WHERE status <> 4 AND tipo_agencia = 'Agencias Proveedoras' ";
              $result = $conn->query( $sql );
              if ( $result->num_rows > 0 ) {
                while ( $row = $result->fetch_assoc() ) {
                  echo '<option value="' . $row[ 'empresa' ] . '">' . $row[ 'empresa' ] . '</option>';
                }
              }
              ?>
            </select>
          </div>
          <div class="col-md-6 mt-3">
            <label class="form-label" for="costo-proveedor">Costo Proveedor</label>
            <input
                            type="text"
                            id="costo-proveedor"
                            name="costo-proveedor"
                            class="form-control"
                            value="0"
                            onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;"

                          />
          </div>
          <div id="box-arrival" class="row">
            <div class="mt-5">
              <h5 id="cabe1">Informacion de Llegada</h5>
            </div>
            <div class="col-md-12 mt-3">
              <label class="form-label" for="arrival_pickup">Lugar Pick up</label>
              <input id="ap" type="text" value="" name="arrival_pickup" class="form-control" oninput="this.value = this.value.toUpperCase()" />
            </div>
            <div class="col-md-12 mt-3 drop">
              <label class="form-label" for="hotel_llegada" id="cabe2">Hotel o Destino</label>
              <input type="text" id="hotel_llegada" name="arrival_hotel" class="form-control" oninput="this.value = this.value.toUpperCase()"/>
            </div>
            <div class="col-md-6 mt-3">
              <label class="form-label" for="fecha_llegada" id="cabe4">Fecha de Llegada</label>
              <input
                            type="text"
                            id="fecha_llegada"
                            name="arrival_date"
                            class="form-control datepicker" autocomplete="off"
							/>
            </div>
            <div class="col-md-6 mt-3">
              <label class="form-label" id="cabe5" for="hora_llegada">Hora de Llegada</label>
              <input
                            type="time"
                            id="hora_llegada"
                            name="arrival_time"
                            class="form-control" 
							/>
            </div>
          </div>
          <div class="aero-llegada row mt-3">
            <div class="col-md-6 d-none">
              <label class="form-label" for="aerolinea_llegada">Aerolinea Llegada</label>
              <input
                            type="text"
                            id="aerolinea_llegada"
                            name="arrival_airline"
                            class="form-control" 
							/>
            </div>
            <div class="col-md-6">
              <label class="form-label" for="vuelo_llegada">Vuelo Llegada</label>
              <input
                            type="text"
                            id="vuelo_llegada"
                            name="arrival_flight"
                            class="form-control" 
                            oninput="this.value = this.value.toUpperCase()"
							/>
            </div>
          </div>
          <div id="box-departure" class="row">
            <div class="mt-5">
              <h5 id="encabezadoSalidas">Informacion de salida</h5>
            </div>
            <div class="col-md-12 mt-3" id="hotel_salida_container">
              <label class="form-label" for="hotel_salida">Hotel</label>
              <input
                            type="text"
                            id="hotel_salida"
                            name="departure_hotel"
                            class="form-control" 
                            oninput="this.value = this.value.toUpperCase()"
							/>
            </div>

            <div class="col-md-12 mt-3" id="departure_destino_container">
              <label class="form-label" id="cabe3" for="departure_destino">Destino</label>
              <input type="text" id="departure_destino" name="departure_destino" class="form-control" value="" oninput="this.value = this.value.toUpperCase()" />
            </div>

            <div class="col-md-4 mt-3" id="departureDateContainer">
              <label class="form-label" for="fecha_salida">Fecha de Salida</label>
              <input type="text" id="fecha_salida" name="departure_date" class="form-control datepicker" autocomplete="off" />
            </div>
            
            <div class="col-md-4 mt-3" id="hs">
              <label class="form-label" for="hora_salida" >Hora de Salida</label>
              <input type="time" id="hora_salida" name="departure_time" class="form-control" />
            </div>

            <div class="col-md-4 mt-3">
              <label class="form-label" for="pickup_time" id="hst">Pickup</label>
              <input type="time" id="pickup_time" name="departure_pickuptime" class="form-control" />
            </div>
          </div>
          
          <div class="aero-salida row mt-3">
            <div class="col-12 col-md-6 d-none">
              <label class="form-label" for="aerolinea_salida">Aerolinea Salida</label>
              <input  type="text" id="aerolinea_salida" name="departure_airline" class="form-control" oninput="this.value = this.value.toUpperCase()" />
            </div>
            <div class="col-12 col-md-6">
              <label class="form-label" for="vuelo_salida">Vuelo Salida</label>
              <input type="text" id="vuelo_salida" name="departure_flight" class="form-control" oninput="this.value = this.value.toUpperCase()" />
            </div>
          </div>
          <div class="row" >
            <div class="mt-5">
              <h5>Extras Services</h5>
            </div>
            <div class="col-md-4">
              <label class="form-label" >Baby Seat</label>
              <input
                                   type="text"
                                   name="bbs"
                                   class="form-control"
                                   value="0"
                                   onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" 
                                   id="bbs"
										 />
            </div>
            <div class="col-md-4">
              <label class="form-label" >Car Seat</label>
              <input
                                   type="text"
                                   name="crs"
                                   class="form-control"
                                   value="0"
                                   onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" 
                                   id="crs"

										 />
            </div>
            <div class="col-md-4">
              <label class="form-label" >Booster Seat</label>
              <input
                                   type="text"
                                   name="bos"
                                   class="form-control"
                                   value="0"
                                   onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" 
                                   id="bos"
										 />
            </div>
            <div class="col-12 mt-3">
              <div class="form-check form-switch">
                <input class="form-check-input" type="checkbox" id="shopping" name="shopping" value="0">
                <label class="form-check-label" for="shopping">Shopping-Stop</label>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-6 mt-3">
              <label class="form-label">Observaciones Para El Cliente</label>
              <textarea class="form-control" id="obs" rows="3" name="obs" oninput="this.value = this.value.toUpperCase()" ></textarea>
              <small class="form-text text-muted">Esta información sera visible en el voucher del cliente</small>
            </div>
            <div class="col-6 mt-3">
              <label class="form-label">Observaciones Internas</label>
              <textarea class="form-control" id="obs_int" rows="3" name="obs_int" oninput="this.value = this.value.toUpperCase()" ></textarea>
              <small class="form-text text-muted">Esta información no la vera en cliente</small> </div>
          </div>
          <div class="col-12 text-center mt-4">
            <button type="button" class="btn btn-primary me-1 me-sm-3" name="add_service" id="crear_reserva">Generar Reserva</button>
            <button
                            type="reset"
                            class="btn btn-label-secondary me-1 me-sm-3"
                            data-bs-dismiss="modal"
                            aria-label="Close"
                          >Cerrar </button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<!--Modal editar reserva -->
<!--Modal editar reserva -->
<div class="modal fade" id="editar_reserva" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-simple modal-edit-user">
    <div class="modal-content p-3 p-md-5">
      <div class="modal-body">
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        <div class="text-center mb-4">
          <h3>Editar Reserva</h3>
        </div>
        <form  class="row g-3" method="post" action="#">
          <div class="col-12 col-md-12">
            <label class="form-label" for="name">Agencia: <span id="prov" class="text-success"></span></label>
            <select name="edit-agencia" class="form-control" id="edit-agencia">
            <?php
              $sql = "SELECT * FROM proveedores WHERE status <> 4 AND tipo_agencia = 'Agencias' ";
              $result = $conn->query( $sql );
              if ( $result->num_rows > 0 ) {
                while ( $row = $result->fetch_assoc() ) {
                  echo '<option value="' . $row[ 'empresa' ] . '">' . $row[ 'empresa' ] . '</option>';
                }
              }
              ?>
              </select>
          </div>
          <div class="col-12 col-md-12">
            <label class="form-label" for="name">Folio Interno</label>
            <input type="text" id="edit-folio" name="folio" class="form-control" />
          </div>
          <div class="col-12 col-md-12">
            <label class="form-label" for="name">Nombre</label>
            <input
            type="text"
            id="edit-name"
            name="name"
            class="form-control" required
            value=""
            />
          </div>
          <div class="col-12 col-md-6">
            <label class="form-label" for="email">email</label>
            <input
            type="text"
            id="edit-email"
            name="email"
            class="form-control" required
            value=""
            />
          </div>
          <div class="col-12 col-md-6">
            <label class="form-label" for="phone">Telefono</label>
            <input
                type="tel"
                            id="edit-phone"
                            name="phone"
                            class="form-control" required
                            value=""
                           
                          />
                        </div>
                        <div class="col-12 col-md-6">
                          <label class="form-label" for="pax">Pax</label>
                          <input type="number" id="edit-pax" name="pax" class="form-control" required value=""/>
                        </div>
                        <div class="col-12 col-md-6">
                          <label class="form-label" for="car">Vehiculo</label>
                          <select name="car" class="form-control car-options" id="edit-car">
                          <option value="Sin Vehiculo">Sin Vehiculo</option>
              <?php
              $sql = "SELECT * FROM cars WHERE status <> 4 ";
              $result = $conn->query( $sql );
              if ( $result->num_rows > 0 ) {
                while ( $row = $result->fetch_assoc() ) {
                  echo '<option value="' . $row[ 'car' ] . '" >' . $row[ 'car' ] . '</option>';
                }
              }
              ?>
                          </select>
                        </div>
                        <div class="col-12 col-md-6">
                          <label class="form-label" for="balance">Pago Recibido</label>
                          <input
                            type="text"
                            id="edit-pagado"
                            name="balance"
                            class="form-control"
                            value="" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" required	 
                          />
                        </div>
                        <div class="col-12 col-md-6">
                          <label class="form-label">Total</label>
                          <input
                            type="text"
                            id="edit-total"
                            name="total"
                            class="form-control"
                            value="" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" required	 
                          />
                        </div>
                        <div class="row" id="llegadas">
                        <div class="mt-5"><h5>Informacion de <span id="txt-servicio">Llegada</span></h5></div>
                        <div class="col-12 col-md-12">
                          <label class="form-label" for="hotel_llegada" id="txt-hotel1">Hotel de Llegada</label>
                          <input type="text" id="edit-hotel-llegada"  name="arrival_hotel" class="form-control" required value=""/>
                        </div>
                        <div class="col-12 col-md-12" id="dropoff-tra">
                          <label class="form-label"  id="txt-hotel2">Lugar de Dropoff</label>
                          <input type="text" id="edit-hotel-pickup"  name="" class="form-control" required value=""/>
                        </div>
                        <div class="col-12 col-md-6">
                          <label class="form-label" for="fecha_llegada">Fecha de Llegada</label>
                          <input
                            type="text" id="edit-fecha-llegada" name="arrival_date" class="form-control datepicker" required value=""/>
                        </div>
                        <div class="col-12 col-md-6">
                          <label class="form-label" for="hora_llegada">Hora de Llegada</label>
                          <input type="text" id="edit-hora-llegada" name="arrival_time" class="form-control" required value=""/>
                        </div>
                        <div class="col-12 col-md-6 hide-tra">
                          <label class="form-label" for="aerolinea_llegada">Aerolinea Llegada</label>
                          <input
                            type="text"
                            id="edit-aerolinea-llegada"
                            name="arrival_airline"
                            class="form-control" required value=""/>
                        </div>
                        <div class="col-12 col-md-6 hide-tra">
                          <label class="form-label" for="vuelo_llegada">Vuelo Llegada</label>
                          <input
                            type="text"
                            id="edit-vuelo-llegada"
                            name="arrival_flight"
                            class="form-control" required value=""/>
                        </div>
                      </div>
                        <div class="row" id="salidas">
                          <div class="mt-5"><h5>Informacion de Salida</h5></div>
                          <div class="col-12 col-md-12">
                            <label class="form-label" for="edit-hotel-salida">Hotel de Salida</label>
                            <input
                            type="text"
                            id="edit-hotel-salida"
                            name="departure_hotel"
                            class="form-control" required
                            value=""/>
                          </div>
                          <div class="col-12 col-md-4">
                          <label class="form-label" for="edit-fecha-salida">Fecha de Salida</label>
                          <input
                            type="text"
                            id="edit-fecha-salida"
                            name="departure_date"
                            class="form-control datepicker" required
                            value=""/>
                          </div>
                          <div class="col-12 col-md-4">
                          <label class="form-label" for="edit-hora-salida">Hora de Salida</label>
                          <input
                            type="text"
                            id="edit-hora-salida"
                            name="edit-hora-salida"
                            class="form-control" required
                            value=""/>
                          </div>
                          <div class="col-12 col-md-4">
                          <label class="form-label" for="edit-pickup-time">Pickup time</label>
                          <input
                            type="text"
                            id="edit-pickup-time"
                            name="edit-pickup-time"
                            class="form-control" required
                            value=""/>
                          </div>
                          <div class="col-12 col-md-6">
                          <label class="form-label" for="aerolinea_salida">Aerolinea Salida</label>
                          <input
                            type="text"
                            id="edit-aerolinea-salida"
                            name="departure_airline"
                            class="form-control" required
                            value=""/>
                          </div>
                          <div class="col-12 col-md-6">
                          <label class="form-label" for="vuelo_salida">Vuelo Salida</label>
                          <input
                            type="text"
                            id="edit-vuelo-salida"
                            name="departure_flight"
                            class="form-control" required
                            value=""/>
                            <input
                            type="hidden"
                            required
                            value=""/>
                            <input
                            type="hidden"
                            name="update_service"
                            required
                            value=""/>
                          </div>
                          
                        </div>
							

                        <div class="mt-5"><h5>Proveedor</h5></div>
                          <div class="col-md-6 mt-3">
            <label class="form-label" for="edit-agencia-proveedor">Proveedor</label>
            <select name="edit-agencia-proveedor" class="form-control" id="edit-agencia-proveedor">
             
              <?php
              $sql = "SELECT * FROM proveedores WHERE status <> 4 AND tipo_agencia = 'Agencias Proveedoras' ORDER BY id ASC";
              $result = $conn->query( $sql );
              if ( $result->num_rows > 0 ) {
                while ( $row = $result->fetch_assoc() ) {
                  echo '<option value="' . $row[ 'id' ] . '">' . $row[ 'empresa' ] . '</option>';
                }
              }
              ?>
            </select>
          </div>
          <div class="col-md-6 mt-3">
            <label class="form-label" for="edit-costo-proveedor">Costo Proveedor</label>
            <input
                            type="text"
                            id="edit-costo-proveedor"
                            name="editar-costo-proveedor"
                            class="form-control"
                            value="0"
                            onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;"

                          />
          </div>
    
						 <div class="row" >
							  <div class="mt-5"><h5>Extras Services</h5></div>
							  <div class="col-md-4">
								  <label class="form-label" for="balance">Baby Seat</label>
								  <input
                                   type="text"
                                   name="bbs"
                                   class="form-control"
                                   value=""
                                   onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;"
                                   id="edit-bbs" 
										 />
								  
							  </div>
							  <div class="col-md-4">
								  <label class="form-label" for="balance">Car Seat</label>
								  <input
                                   type="text"
                                   name="crs"
                                   class="form-control"
                                   value=""
                                   onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" 
                                   id="edit-crs"
										 />
								  
							  </div>
							  <div class="col-md-4">
								  <label class="form-label" for="balance">Booster Seat</label>
								  <input
                                   type="text"
                                   name="bos"
                                   class="form-control"
                                   value=""
                                   onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;" 
                                   id="edit-bos"
										 />
								  
							  </div>
							  <div class="col-6 mt-3">
								  <div class="form-check form-switch">
									  <input class="form-check-input" type="checkbox" id="edit-shopping" name="shopping" value="1">
									  <label class="form-check-label" for="edit-shopping">Shopping-Stop</label>
								  </div>
                            </div>
							<div class="col-6 mt-3">
								  <label for="exampleFormControlTextarea1" class="form-label">Observaciones Internas</label>
                                  <textarea class="form-control" id="edit-obs-int" rows="3" name="obs_int"></textarea>
                            </div>
							
						  </div>
						<div class="col-12 text-center mt-4">
              <input type="hidden" name="update_idr" id="edit-idr" required value=""/>
              <a class="btn btn-label-warning me-1 me-sm-3" target="_blank" href="" id="generar_pdf">Generar PDF</a>
              <button type="button" class="btn btn-label-success actualizar-reserva">Actualizar</button>
              <button
              type="reset"
              class="btn btn-label-secondary me-1 me-sm-3"
              data-bs-dismiss="modal"
              aria-label="Close">Cerrar </button>
            </div>
        </form>
      </div>
    </div>
  </div>
</div>
            <!-- Footer -->
            <?php include('layout/footer.php'); ?>
            <div class="content-backdrop fade"></div>
          </div>

          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>

      <!-- Drag Target Area To SlideIn Menu On Small Screens -->
      <div class="drag-target"></div>
    </div>
    <!-- / Layout wrapper -->

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/libs/hammer/hammer.js"></script>
    <script src="assets/vendor/libs/i18n/i18n.js"></script>
    <script src="assets/vendor/libs/typeahead-js/typeahead.js"></script>
    <script src="assets/vendor/libs/sweetalert2/sweetalert2.js" ></script>

    <script src="assets/vendor/js/menu.js"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js" integrity="sha512-T/tUfKSV1bihCnd+MxKD0Hm1uBBroVYBOYSk1knyvQ9VyZJpc/ALb4P0r6ubwVPSGB2GvjeoMAJJImBG12TiaQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://kit.fontawesome.com/651e797dfa.js" crossorigin="anonymous"></script>

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>
    <!-- Funciones -->

    
    <script>
      $(document).ready(function () {
       $('#costo').keypress(function (e) {
       if (isNaN(String.fromCharCode(e.which))) e.preventDefault();
       });
       //cambiar valor de shopping
        $('#shopping').change(function() {
          if ($(this).is(':checked')) {
            $(this).val('1');
          } else {
            $(this).val('0');
          }
        });
        //cambiar valor de shopping
        $('#noTotal').change(function() {
          if ($(this).is(':checked')) {
            $(this).val('no mostrar');
          } else {
            $(this).val('mostrar');
          }
        });
        $('.datepicker').datepicker({
				   format: 'yyyy-mm-dd'
        });
        $('.service_type').change(function(){
          var service_type = $(this).val()
          if ($(this).val() == "ona") {
             $('#box-arrival').show();
             $('#box-departure').hide();
             $('#cabe1').text('Informacion de llegada');
             $('#cabe2').text('Hotel de Llegada o Destino');
             $('#cabe4').text('Fecha de llegada');
             $('.aero-llegada').show();
             $('.aero-salida').hide();
             $('#cabe5').text('Hora de llegada');
      }
      if ($(this).val() == "ond") {
          $('#box-departure').show();
          $('#box-arrival').hide();
          $('#cabe3').text('Destino');
          $('.aero-salida').show();
          $('.aero-llegada').hide();
          $('#encabezadoSalidas').text('Informacion de salida');
        }
      if ($(this).val() == "roa") {
          $('#box-departure').show();
          $('#box-arrival').show();
          $('#cabe1').text('Informacion de llegada');
          $('#cabe2').text('Hotel de Llegada o Destino');
          $('#cabe3').text('Destino');
          $('.aero-llegada').show();
          $('.aero-salida').hide();
          $('#cabe4').text('Fecha de llegada');
          $('#encabezadoSalidas').text('Informacion de salida');
        }
        if ($(this).val() == "tra") {
          $('#box-arrival').show();
          $('#box-departure').hide();
          $('#cabe1').text('Informacion de traslado (Oneway)');
          $('#cabe2').text('Destino o Actividad');
          $('.drop').show();
          $('.aero').hide();
          $('#cabe4').html('Fecha de servicio');
          $('#cabe5').html('Hora de pickup');
          $('.aero-llegada').hide();
          $('.aero-salida').hide();
          $('#ap').val('');
        }
        if ($(this).val() == "trr") {
          $('#box-arrival').show();
          $('#box-departure').show();
          $('#cabe1').html('IDA');
          $('#cabe2').html('drop off');
          $('#hotel_salida_container').hide();
          $('.drop').show();
          $('.aero').hide();
          $('#cabe4').html('Fecha de servicio');
          $('#cabe5').html('Hora de pickup');
          $('.aero-llegada').hide();
          $('.aero-salida').hide();
          $('#ap').val('');
          $('#encabezadoSalidas').html('REGRESO');
          $('#departureDateContainer').hide();
          $('#departure_destino_container').hide();
          $('#hs').hide();
          $('#hst').text('HORA DE REGRESO');
          
        }
        if ($(this).val() == "ope") {
          $('#box-arrival').show();
          $('#box-departure').hide();
          $('#cabe1').html('Informacion de open');
          $('.drop').hide();
          $('.aero').hide();
          $('#cabe4').html('Fecha de servicio');
          $('#cabe5').html('Hora de pickup');
          $('.aero-llegada').hide();
          $('.aero-salida').hide();
          $('#ap').val('');
        }
    });
      });
      document.getElementById('hora_salida').addEventListener('change', function() {
        let departureTime = this.value;
        console.log(departureTime);
        if (departureTime) {
            // Convertir la hora de salida en un objeto Date
            let departureDate = new Date(`1970-01-01T${departureTime}:00`);

            // Restar 3 horas
            departureDate.setHours(departureDate.getHours() - 3);

            // Formatear la nueva hora para que se ajuste al formato HH:MM
            let hours = departureDate.getHours().toString().padStart(2, '0');
            let minutes = departureDate.getMinutes().toString().padStart(2, '0');

            // Asignar la hora al campo pickup_time
            document.getElementById('pickup_time').value = `${hours}:${minutes}`;
        }
      });
   </script>
    <script src="func/js/get_servicios.js"></script>
    
    
  </body>
</html>