$(document).ready(function() {
  var ida = $('#ida').val();
    $('#zonas_table').DataTable({

        //enviamos el id de la empresa para filtrar las zonas

        ajax: {

          "url": 'func/get_zonas.php',

          "type": 'POST',

          "data": {ida: ida}

        },

        columns: [

            { data: '' },

            { data: 'id' },

            { data: 'zona' },

            { data: 'empresa' },

            { data: 'status' },

            { data: 'id' },

        ],

        columnDefs: [

            {

              // For Responsive

              className: 'control',

              orderable: false,

              responsivePriority: 2,

              searchable: false,

              targets: 0,

              render: function(data, type, full, meta) {

                return '';

              }

            },

            {

                targets: 1,

                searchable: false,

                visible: false,

            },



              {

                targets: 2,

                searchable: true,

              },

              

          

                {

                    targets: 3,

                    searchable: true,

                },

                {

                  targets: 4,

                  searchable: true,

                },

                {

                    targets: 5,

                    searchable: false,

                    render: function(data, type, full, meta) {

                      // boton eliminar

                        return '<button class="btn btn-danger btn-sm" id="eliminar_zona" data-datos="'+data+'" >Eliminar</button>';

                    }

                }



        ],

        order: [[3, 'asc']]

    });

});



$('#zonas_table').on('click', '#eliminar_zona', function() {

  var datos = $(this).data('datos');

  //alert de sweetalert2 para confirmar la eliminación

  Swal.fire({

    title: '¿Estás seguro?',

    icon: 'question',

    showCancelButton: true,

    cancelButtonText: 'Cancelar',

    confirmButtonText: 'Sí, bórralo!'

  }).then((result) => {

    if (result.isConfirmed) {

      // si el usuario confirma la eliminación

      $.ajax({

        type: "POST",

        url: "func/get_zonas.php",

        data: {id:datos, eliminar:'eliminar'},

        success: function(data) {

          var data = JSON.parse(data);

          console.log(data);

          if (data.status === 'success') {

            Swal.fire(

              'Eliminado!',

              data.message,

              'success'

            );

            location.reload();

          } else if (data.status === 'error') {

            Swal.fire(

              'Error!',

              data.message,

              'error'

            );

          } else {

            Swal.fire(

              'Error!',

              'Respuesta desconocida',

              'error'

            );

          }

        }

      });

    }

  });

});





$('#guardar_zona').on('click', function() {

  // mostramos el modal



  var zona = $('#crear-zona').val();

  var empresa = $('#ida').val();

  var insert = 'insert';



  console.log(zona);

  console.log(empresa);

  console.log(insert);



  $.ajax({

    type: "POST",

    url: "func/get_zonas.php",

    data: {zona:zona, empresa:empresa, insert:insert},

    success: function(data) {

      var data = JSON.parse(data);

      console.log(data);

      if (data.status === 'success') {

        alert(data.message);

        location.reload();

      } else if (data.status === 'error') {

        alert(data.message);

      } else {

        alert('Respuesta desconocida');

      }

    }

  });

});