$(document).ready(function() {

  var ida = $('#ida').val();

    $('#tarifas_table').DataTable({

      ajax: {

        url: 'func/get_tarifas_zonas.php',

        type: 'POST',

      },

        columns: [

            { data: '' },

            { data: 'id' },

            { data: 'zona' },

            { data: 'tarifa' },

            { data: 'servicio' },

            { data: 'empresa' },

            { data: 'id' },

        ],

        columnDefs: [

            {

              // For Responsive

              className: 'control',

              orderable: false,

              responsivePriority: 2,

              searchable: false,

              targets: 0,

              render: function(data, type, full, meta) {

                return '';

              }

            },

            {

                targets: 1,

                searchable: false,

                visible: false,

            },



              {

                targets: 2,

                searchable: true,

              },

              {

                targets: 3,

                searchable: true,

              },

              {

                    targets: 4,

                    searchable: true,

              },

              {

                  targets: 5,

                  searchable: true,

              },

              {

                    targets: 6,

                    searchable: false,

                    render: function(data, type, full, meta) {

                      // boton eliminar

                        return '<button class="btn btn-danger btn-sm" id="eliminar_tarifa" data-datos="'+data+'" >Eliminar</button><button class="btn btn-warning btn-sm ms-2 editar_tarifa" data-bs-toggle="modal" data-bs-target="#editar_tarifa" data-datos="'+data+'" >Editar</button>';

                    }

              }



        ],

        order: [[2, 'asc']]

    });

});



$('#tarifas_table').on('click', '.editar_tarifa', function() {

  var datos = $(this).data('datos');

  console.log(datos);

  $.ajax({

    type: "POST",

    url: "func/get_tarifas_zonas.php",

    data: { id: datos },

    success: function(data) {

      var data = JSON.parse(data);



      // abrir modal editModal

      $('#id').val(data.data[0].id);

      $('#edit_tarifa').val(data.data[0].tarifa);

      $('#editModal').modal('show');

    }

  });

});



$('#guardarCambiosTarifa').on('click', function() {

  // mostramos el modal



  var tarifa = $('#edit_tarifa').val();

  var id = $('#id').val();

  var metodo = 'update';



  console.log(tarifa);

  console.log(id);

  console.log(metodo);





  $.ajax({

    type: "POST",

    url: "func/get_tarifas_zonas.php",

    data: {tarifa:tarifa, metodo:metodo, id:id},

    success: function(data) {

      var data = JSON.parse(data);

      

      if (data.status === 'success') {

        //alert de sweetalert2 para confirmar la actualizacion de la tarifa
        Swal.fire({
          title: 'Actualizado!',
          html: data.message,
          icon: 'success'
        }).then((result) => {
          if (result.isConfirmed) {
            location.reload();
          }
        });
      
      

      } else if (data.status === 'error') {

        console.log(data);

        alert(data.message);

      } else {

        console.log(data);

        alert('Respuesta desconocida');

      }

    }

  });

});



$('#crear_tarifa').on('click', function() {

  //obtenemos todas las zonas desde get_zonas.php
  var ida = $('#ida').val();
  $.ajax({
   
    type: "POST",

    url: "func/get_zonas.php",

    data: {ida: ida},

    success: function(data) {

      var zonasData = JSON.parse(data);

      console.log(zonasData);



      // Crear un elemento <select> para las zonas

      var selectZonas = '<select id="crear_zona_select" name="crear_zona" class="form-select zonas-select">';

      selectZonas += '<option value="">Selecciona una zona</option>';



      // Agregar las opciones de las zonas disponibles

      var uniqueZonas = zonasData.data.filter((zona, index, self) =>

        index === self.findIndex((t) => (

          t.zona === zona.zona 

        ))

      );



      //defino la zona actual en las opciones del select por defecto

  



      for (var i = 0; i < uniqueZonas.length; i++) {

        selectZonas += '<option value="' + uniqueZonas[i].zona + '">' + uniqueZonas[i].zona + '</option>';

      }



      selectZonas += '</select>';



      // Eliminar cualquier elemento <select> existente y luego insertar el nuevo elemento <select> en el modal

      $('#crear_zona_select').remove();

      $('#crear_tarifa_modal #zs').append(selectZonas);





    }

  });

});



$('#guardar_tarifa').on('click', function() {

  // mostramos el modal



  var zona = $('#crear_zona_select').val();

  var tarifa = $('#crear-tarifa-input').val();

  var servicio = $('#crear-servicio').val();

  var empresa = $('#ida').val();	

  var insert = 'insert';



  console.log(zona);

  console.log(tarifa);

  console.log(servicio);

  console.log(empresa);

  console.log(insert);



  $.ajax({

    type: "POST",

    url: "func/get_tarifas_zonas.php",

    data: {zona:zona, tarifa:tarifa, metodo:insert, servicio:servicio, empresa:empresa},

    success: function(data) {

      var data = JSON.parse(data);

      console.log(data);

      if (data.status === 'success') {

        alert(data.message);

        location.reload();

      } else if (data.status === 'error') {

        alert(data.message);

      } else {

        console.log(data);

        alert('Respuesta desconocida');

      }

    }

  });

});



$('#tarifas_table').on('click', '#eliminar_tarifa', function() {

  var datos = $(this).data('datos');

  //alert de sweetalert2 para confirmar la eliminación

  Swal.fire({

    title: '¿Estás seguro?',

    icon: 'question',

    showCancelButton: true,

    cancelButtonText: 'Cancelar',

    confirmButtonText: 'Sí, bórralo!'

  }).then((result) => {

    if (result.isConfirmed) {

      // si el usuario confirma la eliminación

      $.ajax({

        type: "POST",

        url: "func/get_tarifas_zonas.php",

        data: {id:datos, metodo:'eliminar'},

        success: function(data) {

          var data = JSON.parse(data);

          console.log(data);

          if (data.status === 'success') {

            Swal.fire(

              'Eliminado!',

              data.message,

              'success'

            ).then((result) => {

              if (result.isConfirmed) {

                location.reload();

              }

            });

            

          } else if (data.status === 'error') {

            Swal.fire(

              'Error!',

              data.message,

              'error'

            );

          } else {

            Swal.fire(

              'Error!',

              'Respuesta desconocida',

              'error'

            );

          }

        }

      });

    }

  });

});