$(document).ready(function() {
  

    $('#hoteles_table').DataTable({

        ajax: 'func/get_hoteles.php',

        columns: [

            { data: '' },

            { data: 'id' },

            { data: 'hotel' },

            { data: 'zona' },

            { data: 'empresa' },

            { data: 'id' },

        ],

        columnDefs: [

            {

              // For Responsive

              className: 'control',

              orderable: false,

              responsivePriority: 2,

              searchable: false,

              targets: 0,

              render: function(data, type, full, meta) {

                return '';

              }

            },

            {

                targets: 1,

                searchable: false,

                visible: false,

            },



              {

                targets: 2,

                searchable: true,

              },

              

          

                {

                    targets: 3,

                    searchable: true,

                },

                {

                  targets: 4,

                  searchable: true,

                },

                {

                    targets: 5,

                    searchable: false,

                    render: function(data, type, full, meta) {

                      // boton eliminar

                        return '<button class="btn btn-danger btn-sm" id="eliminar_hotel" data-datos="'+data+'" >Eliminar</button><button class="btn btn-warning btn-sm ms-2 editar_hotel" data-bs-toggle="modal" data-bs-target="#editar_hotel" data-datos="'+data+'" data-zona="'+full.zona+'" >Editar</button>';

                    }

                }



        ],

        order: [[3, 'asc']]

    });

});



$('#hoteles_table').on('click', '.editar_hotel', function() {

  var datos = $(this).data('datos');

  var zonaActual = $(this).data('zona');

  console.log(zonaActual, datos);

  $.ajax({

    type: "POST",

    url: "func/get_hoteles.php",

    data: { id: datos },

    success: function(data) {

      var data = JSON.parse(data);



      // abrir modal editModal

      $('#id').val(data.data[0].id);

      $('#edit_hotel').val(data.data[0].hotel);



      // Ahora, obtenemos las zonas disponibles

      $.ajax({

        type: "POST",

        url: "func/get_zonas.php", // Cambia esto al archivo que obtiene las zonas disponibles

        success: function(data) {

          var zonasData = JSON.parse(data);

          console.log(zonasData);



        

          // Crear un elemento <select> para las zonas

          var selectZonas = '<select id="edit_zona_select" name="edit_zona" class="form-select">';

          selectZonas += '<option value="">Selecciona una zona</option>';





          // Agregar las opciones de las zonas disponibles

          var uniqueZonas = zonasData.data.filter((zona, index, self) =>

            index === self.findIndex((t) => (

              t.zona === zona.zona 

            ))

          );



          //defino la zona actual en las opciones del select por defecto



          selectZonas += '<option value="' + zonaActual + '" selected>' + zonaActual + '</option>';



          for (var i = 0; i < uniqueZonas.length; i++) {

            selectZonas += '<option value="' + uniqueZonas[i].zona + '">' + uniqueZonas[i].zona + '</option>';

          }



          selectZonas += '</select>';



          // Eliminar cualquier elemento <select> existente y luego insertar el nuevo elemento <select> en el modal

          $('#editar_hotel .modal-body select').remove();

          $('#editar_hotel .modal-body').append(selectZonas);

        }

      });



      $('#editModal').modal('show');

    }

  });

});



$('#guardarCambiosHotel').on('click', function() {

  // mostramos el modal



  var hotel = $('#edit_hotel').val();

  var zona = $('#edit_zona_select').val();

  var id = $('#id').val();

  var metodo = 'update';







  $.ajax({

    type: "POST",

    url: "func/get_hoteles.php",

    data: {hotel:hotel, zona:zona, metodo:metodo, id:id},

    success: function(data) {

      var data = JSON.parse(data);

      

      if (data.status === 'success') {

        alert(data.message);

        location.reload();

      } else if (data.status === 'error') {

        console.log(data);

        alert(data.message);

      } else {

        console.log(data);

        alert('Respuesta desconocida');

      }

    }

  });

});



$('#hoteles_table').on('click', '#eliminar_hotel', function() {

  var datos = $(this).data('datos');

  //alert de sweetalert2 para confirmar la eliminación

  Swal.fire({

    title: '¿Estás seguro?',

    icon: 'question',

    showCancelButton: true,

    cancelButtonText: 'Cancelar',

    confirmButtonText: 'Sí, bórralo!'

  }).then((result) => {

    if (result.isConfirmed) {

      // si el usuario confirma la eliminación

      $.ajax({

        type: "POST",

        url: "func/get_hoteles.php",

        data: {id:datos, metodo:'eliminar'},

        success: function(data) {

          var data = JSON.parse(data);

          console.log(data);

          if (data.status === 'success') {

            Swal.fire(

              'Eliminado!',

              data.message,

              'success'

            );

            location.reload();

          } else if (data.status === 'error') {

            Swal.fire(

              'Error!',

              data.message,

              'error'

            );

          } else {

            Swal.fire(

              'Error!',

              'Respuesta desconocida',

              'error'

            );

          }

        }

      });

    }

  });

});



$('#crear_hotel').on('click', function() {

  //obtenemos todas las zonas desde get_zonas.php

  $.ajax({

    type: "POST",

    url: "func/get_zonas.php",

    success: function(data) {

      var zonasData = JSON.parse(data);

      console.log(zonasData);



      // Crear un elemento <select> para las zonas

      var selectZonas = '<select id="crear_zona_select" name="crear_zona" class="form-select zonas-select">';

      selectZonas += '<option value="">Selecciona una zona</option>';



      // Agregar las opciones de las zonas disponibles

      var uniqueZonas = zonasData.data.filter((zona, index, self) =>

        index === self.findIndex((t) => (

          t.zona === zona.zona 

        ))

      );



      //defino la zona actual en las opciones del select por defecto

  



      for (var i = 0; i < uniqueZonas.length; i++) {

        selectZonas += '<option value="' + uniqueZonas[i].zona + '">' + uniqueZonas[i].zona + '</option>';

      }



      selectZonas += '</select>';



      // Eliminar cualquier elemento <select> existente y luego insertar el nuevo elemento <select> en el modal

      $('#crear_zona_select').remove();

      $('#crear_hotel_modal #zs').append(selectZonas);





    }

  });

});



$('#guardar_hotel').on('click', function() {

  // mostramos el modal



  var zona = $('#crear_zona_select').val();

  var hotel = $('#hotel').val();

  var empresa = 'STATUS';

  var insert = 'insert';



  console.log(zona);

  console.log(hotel); 

  console.log(empresa);

  console.log(insert);



  $.ajax({

    type: "POST",

    url: "func/get_hoteles.php",

    data: {zona:zona, hotel:hotel, empresa:empresa, insert:insert},

    success: function(data) {

      var data = JSON.parse(data);

      console.log(data);

      if (data.status === 'success') {

        alert(data.message);

        location.reload();

      } else if (data.status === 'error') {

        alert(data.message);

      } else {

        console.log(data);

        alert('Respuesta desconocida');

      }

    }

  });

});