$(document).ready(function() {

    var ida = $('#ida').val();

    console.log(ida);

   var tabla = $('#extras_table').DataTable({

        ajax: {

            url: 'func/get_extras.php',

            type: 'POST',

            data: {ida: ida},

        },

        columns: [

            { data: '' },

            { data: 'id' },

            { data: 'servicio' },

            { data: 'costo' },

            { data: 'status' },

            { data: 'empresa' },

            { data: 'id' },

        ],

        columnDefs: [

            {

              // For Responsive

              className: 'control',

              orderable: false,

              responsivePriority: 2,

              searchable: false,

              targets: 0,

              render: function(data, type, full, meta) {

                return '';

              }

            },

            {

                targets: 1,

                searchable: false,

                visible: false,

            },



              {

                targets: 2,

                searchable: true,

              },

              {

                targets: 3,

                searchable: false,

              },

              {

                targets: 4,

                searchable: true,

                render: function(data, type, full, meta) {

                    var statusClass = full.status === 'activo' ? 'btn-success' : 'btn-danger';

                    var statusText = full.status === 'activo' ? 'Activo' : 'Inactivo';

                    return `<button class="btn ${statusClass} btn-sm toggle-status" data-id="${full.id}">${statusText}</button>`;

                }

              },

                {

                    targets: 5,

                    searchable: true,

                },

                {

                    targets: 6,

                    searchable: false,

                    render: function(data, type, full, meta) {

                        

                        return '<button class="btn btn-warning btn-sm edit-btn" data-datos="'+data+'" >Editar</button>';

                    }

                }



        ],

        order: [[3, 'desc']]

    });

});



$(document).ready(function () {

    $('#guardarCambios').click(function () {

        var servicio = $('#servicio').val();

        var costo = $('#costo').val();

        var empresa = $('#empresa').val();

        var id = $('#id').val();

        //mostramos datos en consola

        console.log(servicio);

        console.log(costo);

        console.log(empresa);

        console.log(id);

        var update = true



        $.ajax({

            type: "POST",

            url: "func/get_extras.php",

            data: {servicio: servicio, costo: costo, empresa: empresa, update: update, id: id},

            success: function(response) {

                // cerramos modal

                $('#editModal').modal('hide');

                //limpiamos campos

                $('#servicio').val('');

                $('#costo').val('');

                $('#empresa').val('');

                $('#id').val('');

                //mostramos mensaje de exito con sweetalert2

                Swal.fire(

                    '¡Actualizado!',

                    'El registro ha sido actualizado.',

                    'success'

                );

                //actualizamos tabla

                $('#extras_table').DataTable().ajax.reload();

                

            }

        });

    });

});



$('#extras_table').on('click', '.edit-btn', function() {

    var datos = $(this).data('datos');

    $.ajax({

        type: "POST",

        url: "func/get_extras.php",

        data: {id:datos}, // Aquí se envía el valor de datos como id

        success: function(data) {

            var data = JSON.parse(data);



            // abrir modal editModal

            $('#id').val(data.data[0].id);

            $('#editModal').modal('show');

            $('#servicio').val(data.data[0].servicio);

            $('#costo').val(data.data[0].costo);

            $('#status').val(data.data[0].status);

            $('#empresa').val(data.data[0].empresa);

            

        }

    });

});

$(document).on('click', '.toggle-status', function() {

    var button = $(this);

    var id = button.data('id');

    var currentStatus = button.text().trim() === 'Activo' ? 'activo' : 'inactivo';

    console.log(currentStatus, id);



    // Hacer una solicitud POST para cambiar el estado

    $.ajax({

        url: 'func/update_status_extra.php', // Asegúrate de que esta URL sea correcta

        type: 'POST',

        data: { id: id, status: currentStatus },

        success: function(response) {

            // Actualizar el texto del botón y el color según la respuesta

            if(response.newStatus === 'activo') {

                button.removeClass('btn-danger').addClass('btn-success').text('Activo');

            } else {

                button.removeClass('btn-success').addClass('btn-danger').text('Inactivo');

            }

            //recargamos la tabla

            $('#extras_table').DataTable().ajax.reload();

        },

        error: function() {

            alert('Error al cambiar el estado.');

        }

    });

});