$(document).ready(function() {
    $('#agentes_table').DataTable({
        ajax: 'func/api-get-agentes-tabla.php',
        columns: [
          { data: '' },
          { data: 'idAgente' },
          { data: 'nombreAgente' },
          { data: 'region' },
          { data: 'comision' },
          {data: 'telefonoAgente'},
          {data: 'emailAgente'},
          { data: 'pista' },
          { data: 'idAgente' },
          
         
        ],
        columnDefs: [
            {
              // For Responsive
              className: 'control',
              orderable: false,
              responsivePriority: 2,
              searchable: false,
              targets: 0,
              render: function(data, type, full, meta) {
                return '';
              }
            },
            {
                targets: 1,
                searchable: false,
                visible: false,
            },

              {
                targets: 2,
                searchable: true,
              },
              
          
                {
                    targets: 3,
                    searchable: true,
                },
                {
                  targets: 4,
                  searchable: false,
                },
                {
                  targets: 5,
                  searchable: true,
                },
                {
                  targets: 6,
                  searchable: true,
                },
                {
                  targets: 7,
                  searchable: false,
                },
                {
                    targets: -1,
                    searchable: false,
                    render: function(data, type, full, meta) {
                      // boton eliminar
                        return '<button class="btn btn-danger btn-sm mb-3" id="eliminar_agente" data-datos="'+data+'" >Eliminar</button><button class="btn btn-success btn-sm" id="enviar_invitacion" data-datos="'+data+'" >Enviar invitación</button>';
                    }
                }

        ],
        order: [[3, 'asc']]
    });
});

// funcion para agregar agente
$(document).on('click', '#agregar_agente', function() {
  var nombreAgente = $('#nAgente').val();
  var region = $('#rAgente').val();
  var comision = $('#cAgente').val();
  var telefonoAgente = $('#tAgente').val();
  var emailAgente = $('#eAgente').val();
  var empresaAgente = $('#empresaAgente').val();
  var datos = {
    nombreAgente: nombreAgente,
    region: region,
    comision: comision,
    telefonoAgente: telefonoAgente,
    emailAgente: emailAgente,
    empresaAgente: empresaAgente
  };

  console.log(datos);
  $.ajax({
    url: 'func/api_add_agente.php',
    type: 'POST',
    data: datos,
    success: function(data) {
      //parseamos el json
      var response = JSON.parse(data);
      //recargamos la tabla
      $('#agentes_table').DataTable().ajax.reload();

      //cerramos el modal modal_agregar_agente
      $('#modal_agregar_agente').modal('hide');
    }
  });

});

// funcion para eliminar agente
$(document).on('click', '#eliminar_agente', function() {
  var id = $(this).data('datos');
  console.log(id);
  var datos = {
    id: id
  };
  $.ajax({
    url: 'func/api_delete_agente.php',
    type: 'POST',
    data: datos,
    success: function(data) {
      //parseamos el json
      var response = JSON.parse(data);
      //recargamos la tabla
      $('#agentes_table').DataTable().ajax.reload();
    }
  });
});