<?php
//mostrar errores
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Incluir el archivo de conexión

include 'conn.php'; 
include 'ida.php'; 
//obtenemos datos de la tabla de hoteles si se solicita un id en especifico 

if (isset($_POST['id']) && !isset($_POST['metodo'])) {

  $id = $_POST['id'];

  $stmt = $conn->prepare("SELECT id, zona, tarifa, status FROM tarifas WHERE id = ?");

  $stmt->bind_param("i", $id);

  $stmt->execute();

  // Vincular los resultados a variables
  $stmt->bind_result($id, $zona, $tarifa, $status);



  $datos = array();



  // Obtener los datos en un array asociativo

  while ($stmt->fetch()) {

    // Crear un array asociativo para cada fila
    if ($status== 1) {

      $status = 'Activo';

    } else {

      $status = '';

    }

    $datos[] = array(

      'id' => $id,

      'zona' => $zona,

      'tarifa' => $tarifa,
      
      'status' => $status

    );

  }

  echo json_encode(array("data" => $datos));



  // verificamos si se requiere actualizar la tarifa



} elseif (isset($_POST['metodo']) && $_POST['metodo'] == 'update') {

  $id = $_POST['id'];

  $tarifa = $_POST['tarifa'];



  //actualizamos la tabla


  $stmt = $conn->prepare("UPDATE tarifas SET tarifa = ? WHERE id = ?");
  $stmt->bind_param("ii", $tarifa, $id);
  $stmt->execute();

  // Preparar la consulta SELECT
  $stmt = $conn->prepare("SELECT zona FROM tarifas WHERE id = ?");
  $stmt->bind_param("i", $id);
  $stmt->execute();

  // Vincular el resultado a una variable
  $stmt->bind_result($zona);

  // Obtener el resultado
  $stmt->fetch();






    echo json_encode(array('status' => 'success', 'message' => 'La tarifa de la zona <span class="text-info"><b>' . $zona . '</b></span> ha sido actualizada con éxito. la nueva tarifa es: <span class="text-info"><b>$' . $tarifa . '</b></span>.'));

  

// verificamos si se requiere eliminar un hotel

} elseif (isset($_POST['metodo']) && $_POST['metodo'] == 'eliminar') {

  $id = $_POST['id'];



  //actualizamos la tabla

  $stmt = $conn->prepare("UPDATE tarifas SET status = 2 WHERE id = ?");

  $stmt->bind_param("i", $id);

  $stmt->execute();



  if ($stmt->affected_rows > 0) {

    echo json_encode(array('status' => 'success', 'message' => 'Actualización realizada con éxito.'));

  } else {

    echo json_encode(array('status' => 'error', 'message' => 'La actualización falló: ' . $stmt->error));

  }

// mostramos todos los hoteles

} elseif (isset($_POST['metodo']) && $_POST['metodo'] == 'insert') {


  $tarifa = $_POST['tarifa'];
  $zona = $_POST['zona'];
  $servicio = $_POST['servicio'];


 

  //insertamos en la tabla

  $stmt = $conn->prepare("INSERT INTO tarifas (tarifa, zona, service_type, ida, agencia) VALUES (?, ?, ?, ?, ?)");

  $stmt->bind_param("iisss", $tarifa, $zona, $servicio, $ida, $ida);

  $stmt->execute();



  if ($stmt->affected_rows > 0) {

    echo json_encode(array('status' => 'success', 'message' => '¡Excelente! Has agregado la tarifa correctamente. Ahora, puedes continuar añadiendo hoteles y destinos a la zona. Simplemente dirígete a la sección de HOTELES para hacerlo.'));

  } else {

    echo json_encode(array('status' => 'error', 'message' => 'La inserción falló: ' . $stmt->error));

  }

 // autualizamos tabla generales

 $stmt2 = $conn->prepare("UPDATE generales SET new = 2 WHERE ida = ?");

 $stmt2->bind_param("s", $ida);

  $stmt2->execute();

} else {
  $stmt = $conn->prepare("SELECT DISTINCT z.zona, z.ida, t.tarifa, t.service_type, t.ida, t.id 
    FROM zonas z 
    LEFT JOIN tarifas t ON z.zona = t.zona 
    WHERE z.status = 1 AND t.ida = z.ida AND t.status = 1 AND t.ida = ? 
    ORDER BY z.zona ASC, t.service_type ASC");

  $stmt->bind_param("s", $ida);
  $stmt->execute();

  $stmt->bind_result($zona, $ida_result, $tarifa, $service_type, $ida2, $id);

  $datos = array();

  while ($stmt->fetch()) {
      if ($tarifa === null) {
          $tarifa = 'Sin tarifa';
      }

      $datos[] = array(
          'zona' => $zona,
          'tarifa' => $tarifa,
          'empresa' => $ida_result,
          'id' => $id,
          'servicio' => $service_type
      );
  }

  header('Content-Type: application/json'); // <- MUY IMPORTANTE
  echo json_encode(array("data" => $datos));
}


// Cerrar la declaración
$stmt->close();
// Cerrar la conexión

$conn->close();

?>