<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $promoCode = $_POST['promo_code'];
    $total = $_POST['total'];
    
include 'conn.php';

    $sql = "SELECT * FROM cupones WHERE cupon = ?";
    $stmt = $conn->prepare($sql);

    if (!$stmt) {
        echo json_encode(['error' => 'Error al preparar la consulta: ' . $conn->error]);
        exit;
    }

    $stmt->bind_param("s", $promoCode);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $tipo = $row['tipo'];
        $valor = $row['valor'];
        $cantidadDisponible = $row['cantidad_disponible'];

        if ($cantidadDisponible > 0) {
            if ($tipo === "/") {
                $descuento = $total * ($valor / 100);
                $totalConDescuento = $total - $descuento;
            } elseif ($tipo === "-") {
                $descuento = $valor;
                $totalConDescuento = $total - $valor;
            }

            $newCantidadDisponible = $cantidadDisponible - 1;
            $updateSql = "UPDATE cupones SET cantidad_disponible = ? WHERE cupon = ?";
            $updateStmt = $conn->prepare($updateSql);
            $updateStmt->bind_param("is", $newCantidadDisponible, $promoCode);
            $updateStmt->execute();

            if ($newCantidadDisponible === 0) {
                $updateActivoSql = "UPDATE cupones SET activo = '2' WHERE cupon = ?";
                $updateActivoStmt = $conn->prepare($updateActivoSql);
                $updateActivoStmt->bind_param("s", $promoCode);
                $updateActivoStmt->execute();
            }

            echo json_encode([
                'descuento' => $descuento,
                'totalConDescuento' => $totalConDescuento
            ]);
        } else {
            echo json_encode(['error' => 'All coupons have been redeemed. No more discounts available.']);
        }
    } else {
        echo json_encode(['error' => 'Invalid coupon code. Unable to redeem.']);
    }

    $stmt->close();
    $updateStmt->close();
    $conn->close();
} else {
    echo json_encode(['error' => 'Error: Método de solicitud incorrecto']);
}
?>





