<?php

//mostramos errores

ini_set('display_errors', 1);

ini_set('display_startup_errors', 1);

error_reporting(E_ALL);



// Conexión a la base de datos



include 'conn.php';



//obtenemos datos de la tabla de hoteles si se solicita un id en especifico 



if (isset($_GET['id']) && !isset($_POST['metodo'])) {

  $id = $_GET['id'];

  $stmt = $conn->prepare("SELECT id, zona, hotel FROM hoteles WHERE id = ?");

  $stmt->bind_param("i", $id);

  $stmt->execute();



  // Vincular los resultados a variables

  $stmt->bind_result($id, $zona, $hotel);



  $datos = array();



  // Obtener los datos en un array asociativo

  while ($stmt->fetch()) {

    // Crear un array asociativo para cada fila

    $datos[] = array(

      'id' => $id,

      'zona' => $zona,

      'hotel' => $hotel

    );

  }

} elseif (isset($_POST['insert'])) {

  $zona = $_POST['zona'];

  $empresa = $_POST['empresa'];

  $hotel = $_POST['hotel'];

  //insertamos en la tabla

  $stmt = $conn->prepare("INSERT INTO hoteles (zona, ida, hotel) VALUES (?, ?, ?)");

  $stmt->bind_param("sss", $zona, $empresa, $hotel);

  $stmt->execute();



  if ($stmt->affected_rows > 0) {

    echo json_encode(array('status' => 'success', 'message' => '¡Muy bien! La actualización del Hotel o destino se ha realizado con éxito. Ahora, este se muestra en tu sitio web para que los usuarios puedan reservar.'));

  } else {

    echo json_encode(array('status' => 'error', 'message' => 'La inserción falló: ' . $stmt->error));

  }

// verificamos si se requiere actualizar un hotel



} elseif (isset($_POST['metodo']) && $_POST['metodo'] == 'update') {



  $id = $_POST['id'];

  $zona = $_POST['zona'];

  $hotel = $_POST['hotel'];



  //actualizamos la tabla

  $stmt = $conn->prepare("UPDATE hoteles SET zona = ?, hotel = ? WHERE id = ?");

  $stmt->bind_param("isi", $zona, $hotel, $id);

  $stmt->execute();



  if ($stmt->affected_rows > 0) {

    echo json_encode(array('status' => 'success', 'message' => 'Actualización realizada con éxito.'));

  } else {

    echo json_encode(array('status' => 'error', 'message' => 'La actualización falló: ' . $stmt->error));

  }

// verificamos si se requiere eliminar un hotel

} elseif (isset($_POST['metodo']) && $_POST['metodo'] == 'eliminar') {

  $id = $_POST['id'];



  //actualizamos la tabla

  $stmt = $conn->prepare("UPDATE hoteles SET status = 2 WHERE id = ?");

  $stmt->bind_param("i", $id);

  $stmt->execute();



  if ($stmt->affected_rows > 0) {

    echo json_encode(array('status' => 'success', 'message' => 'Actualización realizada con éxito.'));

  } else {

    echo json_encode(array('status' => 'error', 'message' => 'La actualización falló: ' . $stmt->error));

  }

// mostramos todos los hoteles

} else {
  include 'ida.php';

  $stmt = $conn->prepare("SELECT id, zona, hotel, status, ida FROM hoteles WHERE status = 1 AND ida = ? ORDER BY zona ASC");

  if ($stmt === false) {
      die('Error en la consulta SQL: ' . $conn->error);
  }
  
  $stmt->bind_param('s', $ida);
  $stmt->execute();
  
  // Vincular los resultados a variables
  $stmt->bind_result($id, $zona, $hotel, $status, $ida);



  // Obtener los datos en un array asociativo

  while ($stmt->fetch()) {

    // Procesar el estado

    if ($status == 1) {

        $status = 'Activo';

    } else {

        $status = 'Inactivo';

    }



    // Crear un array asociativo para cada fila

    $datos[] = array(

        'id' => $id,

        'zona' => $zona,

        'hotel' => $hotel,

        'empresa' => $ida,

        'ida' => $ida

    );

  }



  echo json_encode(array("data" => $datos));

}





// Cerrar la declaración

$stmt->close();



// Cerrar la conexión

$conn->close();



?>

