<?php
header('Content-Type: application/json');

// Incluir la conexión a la base de datos
include 'conn.php';

// Verificar la conexión
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed: ' . $conn->connect_error]);
    exit();
}

// Obtener las fechas de la solicitud AJAX
$input = json_decode(file_get_contents("php://input"), true);
$start_date = isset($input['start_date']) ? $input['start_date'] : null;
$end_date = isset($input['end_date']) ? $input['end_date'] : null;

// Validar las fechas
if (!$start_date || !$end_date) {
    http_response_code(400);
    echo json_encode(['error' => 'Las fechas de inicio y fin son necesarias.']);
    exit();
}

// Consulta para cuentas por pagar
$query1 = "SELECT tp.proveedor_id, p.empresa, SUM(tp.monto) AS total_pagar
          FROM proveedores p
          JOIN transacciones_proveedores tp ON p.id = tp.proveedor_id
          WHERE tp.tipo_transaccion = 'cobrar' 
          AND tp.estado = 'pendiente'
          AND tp.fecha_transaccion BETWEEN ? AND ?
          GROUP BY p.empresa
          ORDER BY total_pagar DESC";

$stmt1 = $conn->prepare($query1);
$stmt1->bind_param("ss", $start_date, $end_date);
$stmt1->execute();
$result1 = $stmt1->get_result();

// Almacenar los datos de cuentas por pagar
$cuentas_por_pagar = [];
while ($row = $result1->fetch_assoc()) {
    $cuentas_por_pagar[] = $row;
}

// Consulta para la tabla reservas
$query2 = "SELECT * FROM reservas
          WHERE arrival_date BETWEEN ? AND ? 
          OR departure_date BETWEEN ? AND ?";

$stmt2 = $conn->prepare($query2);
$stmt2->bind_param("ssss", $start_date, $end_date, $start_date, $end_date);
$stmt2->execute();
$result2 = $stmt2->get_result();

// Almacenar los datos de reservas
$reservas = [];
while ($row = $result2->fetch_assoc()) {
    $reservas[] = $row;
}

// Devolver los resultados como JSON
echo json_encode([
    'cuentas_por_pagar' => $cuentas_por_pagar,
    'reservas' => $reservas
]);
?>

