$(document).ready(function() {
    var tableAgencia = $('#agencia_table').DataTable({
        ajax: {
            url: 'func/getAgencias.php',
            dataSrc: 'data' // Indica que los datos están en el array 'data'
        },
        columns: [
            { data: null }, // Columna para enumerar los registros
            { data: 'id' },
            { data: 'empresa' },
            { data: 'telefono' },
            { data: 'email' },
            { data: 'tipo_agencia' },
            { data: 'id' }
        ],
        columnDefs: [
            {
                className: 'control',
                orderable: false,
                responsivePriority: 2,
                searchable: false,
                targets: 0
            },
            {
                targets: 1,
                searchable: false,
                visible: false
            },
            {
                targets: -1,
                searchable: false,
                render: function(data, type, full, meta) {
                    return '<i class="fa-solid fa-trash text-danger delete" data-id="'+data+'" data-name="'+full.empresa+'"></i>';
                }
            }
        ],
        
        drawCallback: function(settings) {
            var api = this.api();
            api.rows({ page: 'current' }).every(function (rowIdx) {
                var data = this.data();
                // Asignar el número de fila en la primera columna
                $('td:eq(0)', this.node()).html(rowIdx + 1);
            });
        }
    });

    var tableProveedores = $('#proveedores_table').DataTable({
        ajax: {
            url: 'func/getProveedores.php',
            dataSrc: 'data' // Indica que los datos están en el array 'data'
        },
        columns: [
            { data: null }, // Columna para enumerar los registros
            { data: 'id' },
            { data: 'empresa' },
            { data: 'telefono' },
            { data: 'email' },
            { data: 'tipo_agencia' },
            { data: 'id' }
        ],
        columnDefs: [
            {
                className: 'control',
                orderable: false,
                responsivePriority: 2,
                searchable: false,
                targets: 0
            },
            {
                targets: 1,
                searchable: false,
                visible: false
            },
            {
                targets: -1,
                searchable: false,
                render: function(data, type, full, meta) {
                    return '<i class="fa-solid fa-trash text-danger delete" data-id="'+data+'" data-name="'+full.empresa+'"></i>';
                }
            }
        ],
        
        drawCallback: function(settings) {
            var api = this.api();
            api.rows({ page: 'current' }).every(function (rowIdx) {
                var data = this.data();
                // Asignar el número de fila en la primera columna
                $('td:eq(0)', this.node()).html(rowIdx + 1);
            });
        }
    });
    
    //Guardar Proveedor
    $("#proveedorForm").submit(function(e) {
        e.preventDefault();
        
        var name = $("#name").val();
        var email = $("#email").val();
        var phone = $("#phone").val();
        var tipo = $("#tipo").val();
        
        if (name === "") {
            alert("El campo de nombre no puede estar vacío.");
            return;
        }
        
        var emailPattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/;
        if (!emailPattern.test(email)) {
            alert("El campo de correo electrónico no es válido.");
            return;
        }
        
        $.ajax({
            type: "POST",
            url: "func/agregar_proveedor.php",
            data: $("#proveedorForm").serialize(),
            success: function(response) {
                if(response == "success"){
                    
                    Swal.fire({
                        title: 'Proveedor Agregado con Éxito',
                        icon: 'success',
                        timer: 1900,
                        showConfirmButton: false
                    }).then(function() {
                        location.reload();
                    });
                }else{
                    alert(response);
                    location.reload();
                }
            },
            error: function(xhr, status, error) {
                alert("Error al enviar el formulario.");
            }
        });
    });
  
    $('#proveedores_table tbody').on('click', '.delete', function() {
        var id = $(this).data('id');
        var name = $(this).data('name');
        
        Swal.fire({
            title: 'Estas Seguro?',
            html: "Eliminaras a <b class='text-warning'>" + name + "</b> de tu lista de proveedores.",
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Confirmar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "func/delete-proveedor.php",
                    method: "POST",
                    data: { id: id },
                    success: function(response) {
                        Swal.fire({
                            title: 'Proveedor Eliminado',
                            html: "Tu lista de Proveedores ha sido actualizada",
                            icon: 'success',
                            showCancelButton: false,
                            confirmButtonColor: '#3085d6',
                            confirmButtonText: 'Ok, Gracias.'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                location.reload();
                            }
                        });
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    }
                });
            }
        });
    });
    $('#agencia_table tbody').on('click', '.delete', function() {
        var id = $(this).data('id');
        var name = $(this).data('name');
        
        Swal.fire({
            title: 'Estas Seguro?',
            html: "Eliminaras a <b class='text-warning'>" + name + "</b> de tu lista de proveedores.",
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Confirmar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "func/delete-proveedor.php",
                    method: "POST",
                    data: { id: id },
                    success: function(response) {
                        Swal.fire({
                            title: 'Proveedor Eliminado',
                            html: "Tu lista de Proveedores ha sido actualizada",
                            icon: 'success',
                            showCancelButton: false,
                            confirmButtonColor: '#3085d6',
                            confirmButtonText: 'Ok, Gracias.'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                location.reload();
                            }
                        });
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    }
                });
            }
        });
    });
  });
  
  

function add_proveedor(){

    
    var proveedor = $("#proveedor").val();
    var idr = $("#idr-proveedor").val();
    var tipo = $("#tipo").val();
    console.log(proveedor);
    console.log(idr);
  
    $.ajax({
        type: "POST",
        url: "func/add_proveedor.php",
        data: {proveedor:proveedor, idr:idr, tipo:tipo},
        success: function(response) {
            var data = JSON.parse(response);
            console.log(data);
  
            if(data.response == 'success'){
                //alert de sweetalert2 para confirmar que se agrego el chofer on un timer para luego recargar la pagina
                Swal.fire({
                    title: 'Proveedor Asignado con Éxito',
                    icon: 'success',
                    timer: 1900,
                    showConfirmButton: false
                }).then(function() {
                    location.reload();
                });
  
            }else{
                //alert de sweetalert2 para confirmar que no se agrego el chofer on un timer para luego recargar la pagina
                Swal.fire({
                    title: 'No se pudo asignar el Proveedor',
                    timer: 1500,
                    showConfirmButton: false
                }).then(function() {
                    location.reload();
                });
  
            }
        }
    });
  
    
  
  }

  function actualizar_proveedor(){

    
    var proveedor = $("#actualizarProveedorSelect").val();
    var idr = $("#actualizar-idr-proveedor").val();
    
    console.log(proveedor);
    console.log(idr);
  
    $.ajax({
        type: "POST",
        url: "func/actualizar_proveedor.php",
        data: {proveedor:proveedor, idr:idr},
        success: function(response) {
            var data = JSON.parse(response);
            console.log(data);
  
            if(data.response == 'success'){
                //alert de sweetalert2 para confirmar que se agrego el chofer on un timer para luego recargar la pagina
                Swal.fire({
                    title: 'Proveedor Asignado con Éxito',
                    icon: 'success',
                    timer: 1900,
                    showConfirmButton: false
                }).then(function() {
                    location.reload();
                });
  
            }else{
                //alert de sweetalert2 para confirmar que no se agrego el chofer on un timer para luego recargar la pagina
                Swal.fire({
                    title: 'No se pudo asignar el Proveedor',
                    timer: 1500,
                    showConfirmButton: false
                }).then(function() {
                    location.reload();
                });
  
            }
        }
    });
  
    
  
  }
  
  
  $(document).on("click", ".actualizar-proveedor", function() {
    var idr = $(this).data('idr');
    console.log(idr);
    $("#actualizar-idr-proveedor").val(idr);
    //ejecutamos la funcion add_chofer
   
  });

  $(document).on("click", ".add-proveedor", function() {
    var idr = $(this).data('idr');
    console.log(idr);
    $("#idr-proveedor").val(idr);
    //ejecutamos la funcion add_chofer
   
  });
  
$(document).on("click", "#asignar_proveedor", function() {
    //cerramos el modal de asignar chofer
    $('#add_proveedor').modal('hide');
    add_proveedor();
});

$(document).on("click", "#btn_actualizar_proveedor", function() {
    //cerramos el modal de asignar chofer
    $('#actualizar_proveedor').modal('hide');
    actualizar_proveedor();
});
