<?php
// Conexión a la base de datos
include 'conn.php';

// Verificar la conexión
if ($conn->connect_error) {
    http_response_code(500);
    die("Conexión fallida: " . $conn->connect_error);
    exit();
}

$query = "SELECT * FROM reservas WHERE DATE(arrival_date) = CURDATE() OR DATE(departure_date) = CURDATE() ORDER BY COALESCE(arrival_date, departure_pickuptime) ASC";
$result = $conn->query($query);

// Verificar si hay servicios
if ($result->num_rows > 0) {
    $servicios = [];
    $total_sum = 0;
    $paid_sum = 0;
    $pending_sum = 0;
    while ($row = $result->fetch_assoc()) {
        $servicios[] = $row;
        $total_sum += $row['total'];
        if ($row['pay_method'] == 'Paid') {
            $paid_sum += $row['total'];
        } elseif ($row['pay_method'] == 'Payment Pending' || $row['pay_method'] == 'Pending') {
            $pending_sum += $row['total'];
        }
    }
} else {
    echo "No hay servicios para hoy.";
    exit();
}

$conn->close();

$fecha_actual = date('Y-m-d');

// Generar informe en HTML
$informe = "<h1>Informe Diario de Servicios</h1>";
$informe .= "<table border='1' cellpadding='10'>";
$informe .= "<tr>
                <th>ID</th>
                <th>Nombre</th>
                <th>Status</th>
                <th>Total</th>
                <th>Agencia</th>
                <th>Fecha</th>
                <th>Hora</th>
                <th>Aerolínea y Vuelo</th>
                <th>Hotel</th>
                <th>Método de Pago</th>
            </tr>";

foreach ($servicios as $servicio) {
    $informe .= "<tr>";
    $informe .= "<td>" . $servicio['idr'] . "</td>";
    $informe .= "<td>" . $servicio['name'] . "</td>";
    $informe .= "<td>" . $servicio['status'] . "</td>";
    $informe .= "<td>" . $servicio['total'] . "</td>";
    $informe .= "<td>" . $servicio['agencia'] . "</td>";

    // Cambia la información dependiendo del tipo de servicio
    switch ($servicio['service']) {
        case 'ona':
            $informe .= "<td>" . $servicio['arrival_date'] . "</td>";
            $informe .= "<td>" . $servicio['arrival_time'] . "</td>";
            $informe .= "<td>" . $servicio['arrival_airline'] . " - " . $servicio['arrival_flight'] . "</td>";
            $informe .= "<td>" . $servicio['arrival_hotel'] . "</td>";
            break;
        case 'ond':
            $informe .= "<td>" . $servicio['departure_date'] . "</td>";
            $informe .= "<td>" . $servicio['departure_time'] . "</td>";
            $informe .= "<td>" . $servicio['departure_airline'] . " - " . $servicio['departure_flight'] . "</td>";
            $informe .= "<td>" . $servicio['departure_hotel'] . "</td>";
            break;
        case 'roa':
            // Mostrar información de llegada o salida según la fecha actual
            if ($fecha_actual == $servicio['arrival_date']) {
                $informe .= "<td>" . $servicio['arrival_date'] . "</td>";
                $informe .= "<td>" . $servicio['arrival_time'] . "</td>";
                $informe .= "<td>" . $servicio['arrival_airline'] . " - " . $servicio['arrival_flight'] . "</td>";
                $informe .= "<td>" . $servicio['arrival_hotel'] . "</td>";
            } elseif ($fecha_actual == $servicio['departure_date']) {
                $informe .= "<td>" . $servicio['departure_date'] . "</td>";
                $informe .= "<td>" . $servicio['departure_time'] . "</td>";
                $informe .= "<td>" . $servicio['departure_airline'] . " - " . $servicio['departure_flight'] . "</td>";
                $informe .= "<td>" . $servicio['departure_hotel'] . "</td>";
            } else {
                $informe .= "<td colspan='4'>Información no disponible</td>";
            }
            break;
        case 'tra':
            $informe .= "<td>" . $servicio['arrival_date'] . "</td>";
            $informe .= "<td>" . $servicio['arrival_time'] . "</td>";
            $informe .= "<td>" . $servicio['arrival_airline'] . " - " . $servicio['arrival_flight'] . "</td>";
            $informe .= "<td>" . $servicio['arrival_pickup'] . " - " . $servicio['arrival_hotel'] . "</td>";
            break;
        case 'ope':
            $informe .= "<td>" . $servicio['arrival_date'] . "</td>";
            $informe .= "<td>" . $servicio['arrival_time'] . "</td>";
            $informe .= "<td>" . $servicio['arrival_airline'] . " - " . $servicio['arrival_flight'] . "</td>";
            $informe .= "<td>" . $servicio['arrival_hotel'] . "</td>";
            break;
        default:
            $informe .= "<td colspan='4'>Tipo de servicio no reconocido</td>";
    }

    // Añadir método de pago
    $informe .= "<td>" . $servicio['pay_method'] . "</td>";

    $informe .= "</tr>";
}

$informe .= "</table>";

// Agregar totales al informe
$informe .= "<h2>Totales</h2>";
$informe .= "<p>Total General: $" . number_format($total_sum, 2) . "</p>";
$informe .= "<p>Total Pagado: $" . number_format($paid_sum, 2) . "</p>";
$informe .= "<p>Total Pendiente: $" . number_format($pending_sum, 2) . "</p>";

// Destinatario
$para = "ia@transbook.mx";

// Asunto
$asunto = "Informe Diario de Servicios - " . date("d-m-Y");

// Encabezados
$cabeceras = "MIME-Version: 1.0" . "\r\n";
$cabeceras .= "Content-type:text/html;charset=UTF-8" . "\r\n";
$cabeceras .= "From: ALertas Desert Travel Plus <confirmations@deserttravelplus.com>" . "\r\n";

// Enviar correo
if (mail($para, $asunto, $informe, $cabeceras)) {
    echo "Informe diario enviado exitosamente.";
} else {
    echo "Error al enviar el informe diario.";
}
?>