<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'conn.php';

$ida = $_POST['ida'];
$fecha = $_POST['fecha'];

$conn->set_charset("utf8mb4");
$sql = "SELECT reservas.*, proveedores.empresa 
FROM reservas 
LEFT JOIN proveedores ON reservas.proveedor_id = proveedores.id 
WHERE reservas.ida = ? 
AND reservas.arrival_date = ? 
AND reservas.status != '4'
AND (reservas.service = 'tra' OR reservas.service = 'trr' OR reservas.service = 'ope' OR reservas.service = 'act')";

$stmt = $conn->prepare($sql);
if (!$stmt) {
echo json_encode(["error" => "Error preparando la consulta: " . htmlspecialchars($conn->error)]);
exit;
}

$stmt->bind_param("ss", $ida, $fecha);
$stmt->execute();
$result = $stmt->get_result();

$reservas = [];
if ($result->num_rows > 0) {
while ($row = $result->fetch_assoc()) {
// Mapear el nombre del servicio usando un switch
switch ($row['service']) {
    case 'tra':
        $row['service'] = 'Transfer';
        break;
    case 'trr':
        $row['service'] = 'Transfer Roundtrip';
        break;
    case 'ope':
        $row['service'] = 'Open Service';
        $hotel = $row['arrival_pickup'];
        break;
    case 'act':
        $row['service'] = 'Activity';
        break;
    default:
        $row['service'] = 'Sin servicio asignado';
        break;
}

// Construir las observaciones
$observaciones = $row['obs'];
if (!empty($row['obs_int'])) {
    $observaciones .= ' ' . $row['obs_int'] . '.';
}
if ((int)$row['babyseat'] > 0) {
    $observaciones .= " Baby seat: " . $row['babyseat'] . ".";
}
if ((int)$row['boosterseat'] > 0) {
    $observaciones .= " Booster seat: " . $row['boosterseat'] . ".";
}
if ((int)$row['carseat'] > 0) {
    $observaciones .= " Car seat: " . $row['carseat'] . ".";
}
if ((int)$row['shopping'] > 0) {
    $observaciones .= " Shopping stop: Yes.";
}

// Asegúrate de que todos los campos tengan un valor válido
$row['arrival_hotel'] = !empty($row['arrival_hotel']) ? $row['arrival_hotel'] : 'Sin hotel asignado';

$row['obs'] = $observaciones;
$row['hotel'] = $row['arrival_hotel'];
$reservas[] = $row;
}
}

// Enviar la respuesta en formato JSON
echo json_encode(["data" => $reservas]);

// Cerrar la conexión
$conn->close();

?>