<?php

// Mostramos errores
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Conexión a la base de datos
include 'conn.php';

// Recibimos los parámetros hotel, service, adults, teens y kids desde la URL
$hotel = $_GET['hotel'];
$service = $_GET['service'];
$adults = isset($_GET['adults']) ? (int)$_GET['adults'] : 0; // Asigna valor por defecto 0 si no está definido
$teens = isset($_GET['teens']) ? (int)$_GET['teens'] : 0;     // Lo mismo para adolescentes
$kids = isset($_GET['kids']) ? (int)$_GET['kids'] : 0;        // Lo mismo para niños

// Mostrar los nombres de los hoteles
include 'ida.php';

// Paso 1: Obtenemos la zona del hotel seleccionado
$stmt = $conn->prepare("SELECT zona FROM hoteles WHERE hotel = ? AND ida = ? LIMIT 1");

if ($stmt === false) {
    die('Error en la consulta SQL: ' . $conn->error);
}

$stmt->bind_param('ss', $hotel, $ida);
$stmt->execute();
$stmt->bind_result($zona);
$stmt->fetch();
$stmt->close();

// Si no se encuentra la zona, devolver mensaje de error
if (!$zona) {
    die('No se encontró la zona para el hotel seleccionado.');
}

// Paso 2: Consultamos la tabla de tarifas para obtener la tarifa basada en la zona y el servicio
$stmt = $conn->prepare("SELECT tarifa FROM tarifas WHERE zona = ? AND service_type = ? LIMIT 1");

if ($stmt === false) {
    die('Error en la consulta SQL al obtener la tarifa: ' . $conn->error);
}

$stmt->bind_param('is', $zona, $service);
$stmt->execute();
$stmt->bind_result($tarifa);
$stmt->fetch();
$stmt->close();

// Si no se encuentra la tarifa, devolver mensaje de error
if (!$tarifa) {
    die('No se encontró tarifa para el servicio seleccionado.');
}

// Paso 3: Calcular el total de pasajeros
$total_passengers = $adults + $teens + $kids;

// Paso 4: Ajustar la tarifa en función del número de pasajeros
if ($total_passengers > 5 && $total_passengers <= 10) {
    $tarifa += 20; // Incrementar $20 si hay más de 5 pero menos o igual a 10 pasajeros
} elseif ($total_passengers > 10) {
    $tarifa += 30; // Incrementar $30 si hay más de 10 pasajeros
}

// Paso 5: Devolver la tarifa ajustada en json


// Devolver solo la tarifa ajustada como string
echo $tarifa;

// Cerrar la conexión
$conn->close();

?>

