<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require '../phpmailer/phpmailer/src/Exception.php';
require '../phpmailer/phpmailer/src/PHPMailer.php';
require '../phpmailer/phpmailer/src/SMTP.php';

include 'conn.php';
include 'ida.php';

function GeraHash($qtd) { 
    $Caracteres = '0123456789'; 
    $QuantidadeCaracteres = strlen($Caracteres); 
    $QuantidadeCaracteres--; 
    $Hash = null; 
    for($x = 1; $x <= $qtd; $x++) { 
        $Posicao = rand(0, $QuantidadeCaracteres); 
        $Hash .= substr($Caracteres, $Posicao, 1); 
    } 
    return $Hash; 
}

// Verificar si los datos necesarios fueron enviados
if (isset($_GET['name'], $_GET['email'], $_GET['phone'], $_GET['adults'])) {
    $nombre = $_GET['name'] ?? null;
    $email = $_GET['email'] ?? null;
    $telefono = $_GET['phone'] ?? null;
    $adults = intval($_GET['adults'] ?? 0);
    $teens = intval($_GET['teens'] ?? 0);
    $kids = intval($_GET['kids'] ?? 0);
    $pax = $adults + $teens + $kids;
    $service = $_GET['service'] ?? null;

    // Definir el tipo de vehículo basado en el número de pasajeros
    if ($pax <= 5) {
        $car = 'SUBURBAN';
    } elseif ($pax <= 10) {
        $car = 'VAN';
    } else {
        $car = 'SPRINTER';
    }
    
    // Información común
    $total = floatval($_GET['total'] ?? '0'); 
    $status = 'Confirmed';
    $idr = GeraHash(3) . 'BOT';
    $agencia = 'Website';
    $idm = 'BOT';

    // Si el servicio es de llegada o viaje redondo, obtiene los datos de llegada
    if ($service == 'ona' || $service == 'roa') {
        $arrival_hotel = $_GET['arrival_hotel'] ?? null;
        $arrival_pickup = 'Airport Los Cabos'; 
        $arrival_date = $_GET['arrival_date'] ?? null;
        $arrival_date = date('Y-m-d', strtotime($arrival_date));
        $arrival_time = $_GET['arrival_time'] ?? null;
        $arrival_airline = $_GET['arrival_airline'] ?? null;
    }

    // Si el servicio es de salida o viaje redondo, obtiene los datos de salida
    if ($service == 'ond' || $service == 'roa') {
        $departure_hotel = $_GET['departure_hotel'] ?? null;
        $departure_pickup = $_GET['departure_pickup'] ?? 'Airport Los Cabos'; 
        $departure_date = $_GET['departure_date'] ?? null;
        $departure_date = date('Y-m-d', strtotime($departure_date));
        $departure_time = $_GET['departure_time'] ?? null;
        $departure_pickuptime = $_GET['departure_pickuptime'] ?? null;
        $departure_airline = $_GET['departure_airline'] ?? null;
    }

    $babyseat = $_GET['babyseat'] ?? 0;
    $carseat = $_GET['carseat'] ?? 0;
    $boosterseat = $_GET['boosterseat'] ?? 0;
    $shopping = $_GET['shopping'] ?? null;
    $obs_int = $_GET['obs_int'] ?? null;

    // Preparar la consulta de inserción SQL basada en el tipo de servicio
    if ($service == 'ona') { 
        // Solo llegada
        $stmt = $conn->prepare("INSERT INTO reservas (name, email, phone, pax, car, total, arrival_hotel, arrival_pickup, arrival_date, arrival_time, arrival_airline, babyseat, carseat, boosterseat, stop, obs_int, status, idr, ida, service, agencia, idm, adults, teens, kids) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param('sssissssssssssssssssssiii', $nombre, $email, $telefono, $pax, $car, $total, $arrival_hotel, $arrival_pickup, $arrival_date, $arrival_time, $arrival_airline, $babyseat, $carseat, $boosterseat, $shopping, $obs_int, $status, $idr, $ida, $service, $agencia, $idm, $adults, $teens, $kids);
    } elseif ($service == 'ond') {
        // Solo salida
        $stmt = $conn->prepare("INSERT INTO reservas (name, email, phone, pax, car, total, departure_hotel, departure_destino, departure_date, departure_time, departure_airline, babyseat, carseat, boosterseat, stop, obs_int, status, idr, ida, service, agencia, idm, departure_pickuptime,adults, teens, kids) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param('sssisssssssssssssssssssiii', $nombre, $email, $telefono, $pax, $car, $total, $departure_hotel, $departure_pickup, $departure_date, $departure_time, $departure_airline, $babyseat, $carseat, $boosterseat, $shopping, $obs_int, $status, $idr, $ida, $service, $agencia, $idm, $departure_pickuptime, $adults, $teens, $kids);
    } else {
        // Viaje redondo
        $stmt = $conn->prepare("INSERT INTO reservas (name, email, phone, pax, car, total, arrival_hotel, arrival_pickup, arrival_date, arrival_time, arrival_airline, departure_hotel, departure_destino, departure_date, departure_time, departure_airline, babyseat, carseat, boosterseat, stop, obs_int, status, idr, ida, service, agencia, idm, departure_pickuptime, adults, teens, kids) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param('sssissssssssssssssssssssssssiii', $nombre, $email, $telefono, $pax, $car, $total, $arrival_hotel, $arrival_pickup, $arrival_date, $arrival_time, $arrival_airline, $departure_hotel, $departure_pickup, $departure_date, $departure_time, $departure_airline, $babyseat, $carseat, $boosterseat, $shopping, $obs_int, $status, $idr, $ida, $service, $agencia, $idm, $departure_pickuptime, $adults, $teens, $kids);
    }
    

    // Ejecutar y verificar la inserción
    if ($stmt->execute()) {
        echo json_encode(['idr' => $idr]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Error al crear la reserva.']);
    }

    $stmt->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Faltan datos necesarios para la creación de la reserva.']);
}

$conn->close();

?>




