<?php
//estlabecer conexion con la base de datos
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'conn.php';

// Verificar si los datos necesarios fueron enviados
if (isset($_POST['idr'])) {
    $idr = $_POST['idr'];
    // Preparar y ejecutar la actualización SQL
    $stmt = $conn->prepare("UPDATE reservas SET status=4 WHERE idr=?");
    if ($stmt === false) {
        die('prepare() failed: ' . htmlspecialchars($conn->error));
    }
    $stmt->bind_param("s", $idr);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        echo json_encode(['status' => 'ok', 'message' => 'Reserva eliminada correctamente.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Error al actualizar la reserva o ninguna información fue modificada.']);
    }

    // Cerrar la conexión
    $stmt->close();
    $conn->close();
} else {
    // Faltan datos POST necesarios
    echo json_encode(['status' => 'error', 'message' => 'Faltan datos necesarios para la actualización.']);
}
?>