<?php
// Mostrar errores para depuración
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'conn.php';

// Verificar si los datos necesarios fueron enviados
$required_fields = [
    'idr', 'ida', 'nombre', 'email', 'telefono', 'pax', 'car', 
    'pagado', 'total', 'hotel_llegada', 'hotel_pickup', 'fecha_llegada', 
    'hora_llegada', 'aerolinea_llegada', 'vuelo_llegada', 'hotel_salida', 
    'fecha_salida', 'hora_salida', 'pickup_time', 'aerolinea_salida', 
    'vuelo_salida', 'bbs', 'crs', 'bos', 'shopping', 'obs_internas', 
    'agencia', 'agencia_proveedor', 'costo_proveedor'
];

foreach ($required_fields as $field) {
    if (!isset($_POST[$field])) {
        echo json_encode(['status' => 'error', 'message' => 'Faltan datos: ' . $field]);
        exit;
    }
}

// Asignar variables desde POST
$idr = $_POST['idr'];
$ida = $_POST['ida'];
$nombre = $_POST['nombre'];
$email = $_POST['email'];
$telefono = $_POST['telefono'];
$pax = $_POST['pax'];
$car = $_POST['car'];
$pagado = floatval($_POST['pagado']);
$total = floatval($_POST['total']);
$balance = $total - $pagado; // Calculado en el servidor para seguridad
$hotel_llegada = $_POST['hotel_llegada'];
$hotel_pickup = $_POST['hotel_pickup'];
$fecha_llegada = $_POST['fecha_llegada'];
$hora_llegada = $_POST['hora_llegada'];
$aerolinea_llegada = $_POST['aerolinea_llegada'];
$vuelo_llegada = $_POST['vuelo_llegada'];
$hotel_salida = $_POST['hotel_salida'];
$fecha_salida = $_POST['fecha_salida'];
$hora_salida = $_POST['hora_salida'];
$pickup_time = $_POST['pickup_time'];
$aerolinea_salida = $_POST['aerolinea_salida'];
$vuelo_salida = $_POST['vuelo_salida'];
$bbs = intval($_POST['bbs']);
$crs = intval($_POST['crs']);
$bos = intval($_POST['bos']);
$shopping = intval($_POST['shopping']);
$obs_internas = $_POST['obs_internas'];
$agencia = $_POST['agencia'];
$agencia_proveedor = intval($_POST['agencia_proveedor']);
$costo_proveedor = floatval($_POST['costo_proveedor']);
$folio = $_POST['folio'] ?? null;
$currency = $_POST['currency'] ?? "USD";

// Validar que el proveedor_id exista en la tabla `proveedores`
$proveedor_check = $conn->prepare("SELECT COUNT(*) FROM proveedores WHERE id = ?");
$proveedor_check->bind_param("i", $agencia_proveedor);
$proveedor_check->execute();
$proveedor_check->bind_result($exists);
$proveedor_check->fetch();
$proveedor_check->close();

if ($exists == 0) {
    echo json_encode(['status' => 'error', 'message' => 'El proveedor no existe.']);
    exit;
}

// Preparar y ejecutar la actualización SQL
$stmt = $conn->prepare("
    UPDATE reservas 
    SET 
        name = ?, 
        email = ?, 
        phone = ?, 
        pax = ?, 
        car = ?, 
        pagado = ?, 
        total = ?, 
        arrival_hotel = ?, 
        arrival_pickup = ?, 
        arrival_date = ?, 
        arrival_time = ?, 
        arrival_airline = ?, 
        arrival_flight = ?, 
        departure_hotel = ?, 
        departure_date = ?, 
        departure_time = ?, 
        departure_pickuptime = ?, 
        departure_airline = ?, 
        departure_flight = ?, 
        babyseat = ?, 
        carseat = ?, 
        boosterseat = ?, 
        shopping = ?, 
        obs_int = ?, 
        balance = ?, 
        agencia = ?, 
        proveedor_id = ?, 
        costo_proveedor = ?,
        folio = ?,
        currency = ?
    WHERE idr = ?
");

if ($stmt === false) {
    die('prepare() failed: ' . htmlspecialchars($conn->error));
}

// Vincular los parámetros (29 parámetros)
$stmt->bind_param(
    "sssisssssssssssssssssssssssdsss", 
    $nombre, $email, $telefono, $pax, $car, $pagado, $total, 
    $hotel_llegada, $hotel_pickup, $fecha_llegada, $hora_llegada, 
    $aerolinea_llegada, $vuelo_llegada, $hotel_salida, $fecha_salida, 
    $hora_salida, $pickup_time, $aerolinea_salida, $vuelo_salida, 
    $bbs, $crs, $bos, $shopping, $obs_internas, $balance, 
    $agencia, $agencia_proveedor, $costo_proveedor, $folio, $currency, $idr
);

if (!$stmt->execute()) {
    echo json_encode(['status' => 'error', 'message' => 'Execute failed: ' . htmlspecialchars($stmt->error)]);
} elseif ($stmt->affected_rows > 0) {
    echo json_encode(['status' => 'ok', 'message' => 'Reserva actualizada correctamente.']);
} else {
    echo json_encode(['status' => 'ok', 'message' => 'No se realizaron cambios en la reserva.']);
}

// Cerrar la declaración y la conexión
$stmt->close();
$conn->close();
?>



